/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import com.lying.utility.AbstractBox2f;
import com.lying.utility.Box2f;
import com.lying.utility.CDUtils;
import com.lying.utility.LineSegment2f;
import java.util.List;
import net.minecraft.world.phys.Vec2;

public class RotaryBox2f
extends AbstractBox2f {
    private Vec2[] points = new Vec2[4];
    private LineSegment2f[] edges = new LineSegment2f[4];
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;

    public RotaryBox2f(Vec2 aIn, Vec2 bIn, Vec2 cIn, Vec2 dIn) {
        this.points[0] = aIn;
        this.points[1] = bIn;
        this.points[2] = cIn;
        this.points[3] = dIn;
        this.updateValues();
    }

    @Override
    public String toString() {
        return "RotBox[" + this.minX + "->" + this.maxX + ", " + this.minY + "->" + this.maxY + "]";
    }

    public RotaryBox2f clone() {
        return new RotaryBox2f(this.points[0], this.points[1], this.points[2], this.points[3]);
    }

    public void updateValues() {
        this.calculateSimpleBounds();
        this.buildEdges();
    }

    protected void calculateSimpleBounds() {
        float mx = 2.1474836E9f;
        float my = 2.1474836E9f;
        float mX = -2.1474836E9f;
        float mY = -2.1474836E9f;
        for (Vec2 vec : this.points) {
            float y;
            float x = vec.x;
            if (x > mX) {
                mX = x;
            }
            if (x < mx) {
                mx = x;
            }
            if ((y = vec.y) > mY) {
                mY = y;
            }
            if (!(y < my)) continue;
            my = y;
        }
        this.minX = mx;
        this.minY = my;
        this.maxX = mX;
        this.maxY = mY;
    }

    @Override
    public float minX() {
        return this.minX;
    }

    @Override
    public float minY() {
        return this.minY;
    }

    @Override
    public float maxX() {
        return this.maxX;
    }

    @Override
    public float maxY() {
        return this.maxY;
    }

    protected void buildEdges() {
        this.edges = new LineSegment2f[]{new LineSegment2f(this.points[0], this.points[1]), new LineSegment2f(this.points[1], this.points[2]), new LineSegment2f(this.points[2], this.points[3]), new LineSegment2f(this.points[3], this.points[0])};
    }

    public static RotaryBox2f enclosing(Vec2 a, Vec2 b) {
        float minX = Math.min(a.x, b.x);
        float minY = Math.min(a.y, b.y);
        float maxX = Math.max(a.x, b.x);
        float maxY = Math.max(a.y, b.y);
        return new RotaryBox2f(new Vec2(minX, minY), new Vec2(maxX, minY), new Vec2(maxX, maxY), new Vec2(minX, maxY));
    }

    public static RotaryBox2f ofSize(int width, int height) {
        return new RotaryBox2f(new Vec2(0.0f, 0.0f), new Vec2((float)width, 0.0f), new Vec2((float)width, (float)height), new Vec2(0.0f, (float)height));
    }

    public static RotaryBox2f fromLine(LineSegment2f line, float height) {
        Vec2 p1 = new Vec2(line.getLeft().x, line.getLeft().y);
        Vec2 p2 = new Vec2(line.getRight().x, line.getRight().y);
        Vec2 delta = p2.add(p1.negated()).normalized();
        delta = new Vec2(-delta.y, delta.x);
        float minH = -height / 2.0f;
        float maxH = minH + height;
        Vec2 a = p1.add(delta.scale(minH));
        Vec2 b = p2.add(delta.scale(minH));
        Vec2 c = p2.add(delta.scale(maxH));
        Vec2 d = p1.add(delta.scale(maxH));
        return new RotaryBox2f(new Vec2(a.x, a.y), new Vec2(b.x, b.y), new Vec2(c.x, c.y), new Vec2(d.x, d.y));
    }

    public AbstractBox2f simplify() {
        return new Box2f(this.minX, this.maxX, this.minY, this.maxY);
    }

    @Override
    public List<LineSegment2f> asEdges() {
        return List.of(this.edges[0], this.edges[1], this.edges[2], this.edges[3]);
    }

    @Override
    public List<Vec2> asPoints() {
        return List.of(this.points[0], this.points[1], this.points[2], this.points[3]);
    }

    @Override
    public AbstractBox2f move(Vec2 vec) {
        for (int i = 0; i < 4; ++i) {
            this.points[i] = vec.add(this.points[i]);
        }
        this.updateValues();
        return this;
    }

    @Override
    public AbstractBox2f mul(float val) {
        for (int i = 0; i < 4; ++i) {
            this.points[i] = this.points[i].scale(val);
        }
        this.updateValues();
        return this;
    }

    @Override
    public AbstractBox2f spin(float radians) {
        return this.rotateAround(new Vec2(this.minX + (this.maxX - this.minX) / 2.0f, this.minY + (this.maxY - this.minY) / 2.0f), radians);
    }

    @Override
    public AbstractBox2f rotate(float radians) {
        for (int i = 0; i < 4; ++i) {
            this.points[i] = CDUtils.rotate(this.points[i], radians);
        }
        this.updateValues();
        return this;
    }

    @Override
    public AbstractBox2f rotateAround(Vec2 origin, float radians) {
        return this.move(origin.negated()).rotate(radians).move(origin);
    }

    @Override
    public AbstractBox2f grow(float val) {
        return this;
    }
}

