/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class Vector2iUtils {
    public static Vec2 toVec2f(Vector2i vec) {
        return new Vec2((float)vec.x, (float)vec.y);
    }

    public static Vector2i copy(Vector2i vec) {
        return new Vector2i(vec.x, vec.y);
    }

    public static Vector2i add(Vector2i a, Vector2i b) {
        return new Vector2i(a.x + b.x, a.y + b.y);
    }

    public static Vector2i subtract(Vector2i val, Vector2i from) {
        return new Vector2i(from.x - val.x, from.y - val.y);
    }

    public static Vector2i mul(Vector2i a, double scalar) {
        return new Vector2i((int)((double)a.x * scalar), (int)((double)a.y * scalar));
    }

    public static Vector2i normalize(Vector2i a) {
        return Vector2iUtils.mul(a, 1.0 / a.length());
    }

    public static Vector2i negate(Vector2i a) {
        return Vector2iUtils.mul(a, -1.0);
    }

    @Nullable
    public static Vector2i avg(Vector2i ... values) {
        if (values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        int x = 0;
        int y = 0;
        for (Vector2i vec : values) {
            x += vec.x;
            y += vec.y;
        }
        return new Vector2i(x / values.length, y / values.length);
    }

    public static Vector2i rotate(Vector2i a, double radians) {
        if (radians == Math.toRadians(90.0)) {
            return new Vector2i(-a.y(), a.x());
        }
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        return new Vector2i((int)((double)a.x() * cos - (double)a.y() * sin), (int)((double)a.x() * sin + (double)a.y() * cos));
    }
}

