/*
 * Decompiled with CFR 0.152.
 */
package com.lying.worldgen;

import com.google.common.base.Predicates;
import com.lying.grid.BlueprintTileGrid;
import com.lying.init.CDTileTags;
import com.lying.init.CDTiles;
import com.lying.worldgen.Tile;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TileConditions {
    public static Predicate<Tile> isAnyOf(ResourceLocation ... idsIn) {
        return t -> {
            ResourceLocation id = t.registryName();
            for (ResourceLocation test : idsIn) {
                if (!id.equals((Object)test)) continue;
                return true;
            }
            return false;
        };
    }

    public static Condition always() {
        return (t, p, s) -> true;
    }

    public static Condition never() {
        return (t, p, s) -> false;
    }

    public static Condition not(Condition cond) {
        return (t, p, s) -> !cond.test(t, p, s);
    }

    public static Condition boundary(Direction.Plane type) {
        return TileConditions.boundary(type.stream().toList());
    }

    public static Condition boundary(List<Direction> faces) {
        return (t, p, s) -> faces.stream().anyMatch(d -> s.isBoundary(p, (Direction)d));
    }

    public static Condition nonBoundary() {
        return TileConditions.not(TileConditions.boundary(Direction.stream().toList()));
    }

    public static Condition onFloor() {
        return TileConditions.adjacent(List.of(Direction.DOWN), CDTileTags.SOLID_FLOORING::contains);
    }

    public static Condition onBottomLayer() {
        return TileConditions.boundary(List.of(Direction.DOWN));
    }

    public static Condition onTopLayer() {
        return TileConditions.boundary(List.of(Direction.UP));
    }

    public static Condition nonPassage() {
        return TileConditions.not(TileConditions.passage());
    }

    public static Condition passage() {
        return TileConditions.adjacent(t -> t.registryName().equals((Object)CDTiles.ID_PASSAGE));
    }

    public static Condition adjacent(Predicate<Tile> predicate) {
        return TileConditions.adjacent(Direction.stream().toList(), predicate);
    }

    public static Condition adjacent(Direction.Plane type, Predicate<Tile> predicate) {
        return TileConditions.adjacent(type.stream().toList(), predicate);
    }

    public static Condition adjacent(List<Direction> faces, Predicate<Tile> predicate) {
        return (tile, pos, set) -> faces.stream().map(f -> pos.relative(f)).filter(set::contains).map(p -> set.get(p).get()).filter((Predicate<Tile>)Predicates.not(Tile::isBlank)).anyMatch(predicate);
    }

    public static Condition near(AABB bounds, Predicate<Tile> predicate) {
        int lX = (int)(Math.min(10.0, bounds.getXsize()) * 0.5);
        int lY = (int)(Math.min(10.0, bounds.getYsize()) * 0.5);
        int lZ = (int)(Math.min(10.0, bounds.getZsize()) * 0.5);
        AABB b = AABB.encapsulatingFullBlocks((BlockPos)new BlockPos(-lX, -lY, -lZ), (BlockPos)new BlockPos(lX, lY, lZ));
        return (tile, pos, set) -> {
            AABB box = b.move(pos);
            return !set.getMatchingTiles((p2, t2) -> box.contains(new Vec3((double)p2.getX() + 0.5, (double)p2.getY() + 0.5, (double)p2.getZ() + 0.5)) && predicate.test((Tile)t2)).isEmpty();
        };
    }

    public static Condition near(double distance, Predicate<Tile> predicate) {
        double d = Math.min(10.0, distance);
        return (t, p, s) -> !s.getMatchingTiles((p2, t2) -> p2.closerThan((Vec3i)p, d) && predicate.test((Tile)t2)).isEmpty();
    }

    public static Condition avoid(AABB bounds, Predicate<Tile> tiles) {
        return TileConditions.not(TileConditions.near(bounds, tiles));
    }

    public static Condition avoid(double distance, Predicate<Tile> tiles) {
        return TileConditions.not(TileConditions.near(distance, tiles));
    }

    public static Condition consecutive(List<Direction> faces) {
        return (t, p, s) -> TileConditions.adjacent(faces, t::is).test(t, p, s);
    }

    public static Condition nonConsecutive() {
        return TileConditions.nonConsecutive(Direction.stream().toList());
    }

    public static Condition nonConsecutive(List<Direction> faces) {
        return (t, p, s) -> TileConditions.not(TileConditions.adjacent(faces, t::is)).test(t, p, s);
    }

    public static Condition nonAdjacent(Predicate<Tile> tiles) {
        return TileConditions.nonAdjacent(Direction.stream().toList(), tiles);
    }

    public static Condition nonAdjacent(List<Direction> faces, Predicate<Tile> tiles) {
        return TileConditions.not(TileConditions.adjacent(faces, tiles));
    }

    public static Condition nonConsecutive(AABB box) {
        return (t, p, s) -> TileConditions.avoid(box, t::is).test(t, p, s);
    }

    public static Condition maxOf(int i) {
        return (t, p, s) -> s.tallyOf(t) < i;
    }

    public static Condition maxOf(int i, Predicate<Tile> condition) {
        return (t, p, s) -> s.tallyMatching(condition) < i;
    }

    @FunctionalInterface
    public static interface Condition {
        public boolean test(Tile var1, BlockPos var2, BlueprintTileGrid var3);
    }
}

