/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block;

import com.lying.block.AbstractTrapSensorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CollisionSensorBlock
extends AbstractTrapSensorBlock {
    protected static final AABB UP_BOUNDS = new AABB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375);
    protected static final AABB DOWN_BOUNDS = new AABB(0.0625, 0.9375, 0.0625, 0.9375, 1.0, 0.9375);
    protected static final AABB NORTH_BOUNDS = new AABB(0.0625, 0.0625, 0.875, 0.9375, 0.9375, 1.0);
    protected static final AABB EAST_BOUNDS = new AABB(0.0, 0.0625, 0.0625, 0.125, 0.9375, 0.9375);
    protected static final AABB SOUTH_BOUNDS = new AABB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 0.125);
    protected static final AABB WEST_BOUNDS = new AABB(0.875, 0.0625, 0.0625, 1.0, 0.9375, 0.9375);
    protected static final VoxelShape UP_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    protected static final VoxelShape DOWN_SHAPE = Block.box((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)2.0);
    protected static final VoxelShape WEST_SHAPE = Block.box((double)14.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    protected static final VoxelShape UP_SHAPE_PRESSED = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    protected static final VoxelShape DOWN_SHAPE_PRESSED = Block.box((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape NORTH_SHAPE_PRESSED = Block.box((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE_PRESSED = Block.box((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0);
    protected static final VoxelShape SOUTH_SHAPE_PRESSED = Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    protected static final VoxelShape WEST_SHAPE_PRESSED = Block.box((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;

    public CollisionSensorBlock(BlockBehaviour.Properties settings) {
        super(settings.forceSolidOn().noCollission());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.UP)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean pressed = (Boolean)state.getValue((Property)POWERED);
        switch ((Direction)state.getValue(FACING)) {
            case UP: {
                return pressed ? UP_SHAPE_PRESSED : UP_SHAPE;
            }
            case DOWN: {
                return pressed ? DOWN_SHAPE_PRESSED : DOWN_SHAPE;
            }
            case NORTH: {
                return pressed ? NORTH_SHAPE_PRESSED : NORTH_SHAPE;
            }
            case EAST: {
                return pressed ? EAST_SHAPE_PRESSED : EAST_SHAPE;
            }
            case SOUTH: {
                return pressed ? SOUTH_SHAPE_PRESSED : SOUTH_SHAPE;
            }
            case WEST: {
                return pressed ? WEST_SHAPE_PRESSED : WEST_SHAPE;
            }
        }
        return UP_SHAPE;
    }

    protected static AABB getSearchBounds(Direction face) {
        switch (face) {
            default: {
                return UP_BOUNDS;
            }
            case DOWN: {
                return DOWN_BOUNDS;
            }
            case NORTH: {
                return NORTH_BOUNDS;
            }
            case EAST: {
                return EAST_BOUNDS;
            }
            case SOUTH: {
                return SOUTH_BOUNDS;
            }
            case WEST: 
        }
        return WEST_BOUNDS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getClickedFace());
    }

    @Override
    public int activity(BlockPos pos, Level world) {
        return (Boolean)world.getBlockState(pos).getValue((Property)POWERED) != false ? 15 : 0;
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.updatePowered(null, (Level)world, pos, state, this.shouldBePowered((Level)world, pos, state));
    }

    protected void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!world.isClientSide()) {
            this.updatePowered(entity, world, pos, state, this.shouldBePowered(world, pos, state));
        }
    }

    private void updatePowered(@Nullable Entity entity, Level world, BlockPos pos, BlockState state, boolean power) {
        boolean powerState = (Boolean)state.getValue((Property)POWERED);
        if (powerState != power) {
            BlockState newState = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(power));
            world.setBlock(pos, newState, 2);
            world.setBlocksDirty(pos, state, newState);
        }
        if (!power && powerState) {
            world.playSound(null, pos, SoundEvents.STONE_PRESSURE_PLATE_CLICK_OFF, SoundSource.BLOCKS);
            world.gameEvent(entity, (Holder)GameEvent.BLOCK_DEACTIVATE, pos);
        } else if (power && !powerState) {
            world.playSound(null, pos, SoundEvents.STONE_PRESSURE_PLATE_CLICK_ON, SoundSource.BLOCKS);
            world.gameEvent(entity, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
        }
        if (power) {
            world.scheduleTick(pos, (Block)this, 20);
        }
    }

    protected boolean shouldBePowered(Level world, BlockPos pos, BlockState state) {
        AABB bounds = CollisionSensorBlock.getSearchBounds((Direction)state.getValue(FACING)).move(pos);
        if (world.getEntitiesOfClass(LivingEntity.class, bounds, EntitySelector.NO_SPECTATORS.and(entity -> !entity.isIgnoringBlockTriggers())).size() > 0) {
            return true;
        }
        return world.getEntitiesOfClass(ItemEntity.class, bounds, e -> {
            ItemEntity entity = e;
            ItemStack stack = entity.getItem();
            return stack.getMaxStackSize() <= 16;
        }).size() > 0;
    }
}

