/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block;

import com.lying.block.AbstractTrapActorBlock;
import com.lying.block.RedstoneActorBlock;
import com.lying.block.entity.TrapActorBlockEntity;
import com.lying.init.CDBlockEntityTypes;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HatchActorBlock
extends AbstractTrapActorBlock {
    public static final MapCodec<HatchActorBlock> CODEC = RedstoneActorBlock.simpleCodec(HatchActorBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty INTERSTITIAL = BooleanProperty.create((String)"interstitial");
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape SHAPE_CLOSED = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_OPEN = Shapes.empty();

    public HatchActorBlock(BlockBehaviour.Properties settingsIn) {
        super(settingsIn);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)INTERSTITIAL, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, FACING, INTERSTITIAL});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)INTERSTITIAL, (Comparable)Boolean.valueOf(HatchActorBlock.isInterstitial(ctx.getHorizontalDirection(), (LevelReader)ctx.getLevel(), ctx.getClickedPos())));
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        return (BlockState)state.setValue((Property)INTERSTITIAL, (Comparable)Boolean.valueOf(HatchActorBlock.isInterstitial((Direction)state.getValue(FACING), world, pos)));
    }

    protected static boolean isInterstitial(Direction face, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.relative(face.getOpposite())).getBlock() instanceof HatchActorBlock;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE_CLOSED;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)POWERED) != false ? SHAPE_OPEN : SHAPE_CLOSED;
    }

    @Override
    public boolean isActive(BlockPos pos, Level world) {
        return (Boolean)world.getBlockState(pos).getValue((Property)POWERED);
    }

    @Override
    public void trigger(BlockPos pos, Level world) {
        BlockState state;
        state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf((Boolean)(state = world.getBlockState(pos)).getValue((Property)POWERED) == false));
        world.setBlockAndUpdate(pos, state);
    }

    @Override
    public int wireCount(BlockPos pos, Level world) {
        return ((TrapActorBlockEntity)((Object)world.getBlockEntity(pos, (BlockEntityType)CDBlockEntityTypes.TRAP_ACTOR.get()).get())).wireCount();
    }
}

