/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block;

import com.lying.block.IWireableBlock;
import com.lying.block.entity.ProximitySensorBlockEntity;
import com.lying.init.CDBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ProximitySensorBlock
extends BaseEntityBlock
implements IWireableBlock {
    public static final MapCodec<ProximitySensorBlock> CODEC = ProximitySensorBlock.simpleCodec(ProximitySensorBlock::new);
    private static final VoxelShape UP_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    private static final VoxelShape DOWN_SHAPE = Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;

    public ProximitySensorBlock(BlockBehaviour.Properties settings) {
        super(settings.noOcclusion().emissiveRendering(CDBlocks::always).lightLevel(state -> (Boolean)state.getValue((Property)POWERED) != false ? 4 : 0));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.UP)).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWER, POWERED});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ProximitySensorBlockEntity(pos, state);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue(FACING)) {
            default: {
                return UP_SHAPE;
            }
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case WEST: 
        }
        return WEST_SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getClickedFace());
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> validateTicker(BlockEntityType<A> given, BlockEntityType<E> expected, BlockEntityTicker<? super E> ticker) {
        return expected == given ? ticker : null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return ProximitySensorBlockEntity.getTicker(world, state, type);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    public boolean acceptWireTo(IWireableBlock.WireRecipient type, BlockPos target, BlockPos pos, Level world) {
        return false;
    }

    @Override
    public IWireableBlock.WireRecipient type() {
        return IWireableBlock.WireRecipient.SENSOR;
    }

    @Override
    public int activity(BlockPos pos, Level world) {
        return (Integer)world.getBlockState(pos).getValue((Property)POWER);
    }

    public static void setPower(int value, BlockPos pos, Level world) {
        BlockState state = world.getBlockState(pos);
        if ((Integer)state.getValue((Property)POWER) != value) {
            world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(value))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(value > 0)), 3);
        }
    }
}

