/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block;

import com.lying.block.AbstractTrapActorBlock;
import com.lying.block.entity.TrapActorBlockEntity;
import com.lying.init.CDBlockEntityTypes;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class RedstoneActorBlock
extends AbstractTrapActorBlock {
    public static final MapCodec<RedstoneActorBlock> CODEC = RedstoneActorBlock.simpleCodec(RedstoneActorBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public RedstoneActorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    protected int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
    }

    @Override
    public boolean isActive(BlockPos pos, Level world) {
        return (Boolean)world.getBlockState(pos).getValue((Property)POWERED);
    }

    @Override
    public void trigger(BlockPos pos, Level world) {
        BlockState state;
        state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf((Boolean)(state = world.getBlockState(pos)).getValue((Property)POWERED) == false));
        world.setBlockAndUpdate(pos, state);
    }

    @Override
    public int wireCount(BlockPos pos, Level world) {
        return ((TrapActorBlockEntity)((Object)world.getBlockEntity(pos, (BlockEntityType)CDBlockEntityTypes.TRAP_ACTOR.get()).get())).wireCount();
    }
}

