/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block;

import com.lying.block.AbstractTrapSensorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import org.jetbrains.annotations.Nullable;

public class RedstoneSensorBlock
extends AbstractTrapSensorBlock {
    public RedstoneSensorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        boolean status;
        if (!world.isClientSide() && (status = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != world.hasNeighborSignal(pos)) {
            if (status) {
                world.scheduleTick(pos, (Block)this, 1);
            } else {
                world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !world.hasNeighborSignal(pos)) {
            world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    @Override
    public int activity(BlockPos pos, Level world) {
        int max = 0;
        for (Direction face : Direction.Plane.HORIZONTAL) {
            max = Math.max(max, world.getControlInputSignal(pos.relative(face), face, false));
        }
        return max;
    }
}

