/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block;

import com.lying.block.IWireableBlock;
import com.lying.block.entity.SightSensorBlockEntity;
import com.lying.init.CDBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SightSensorBlock
extends BaseEntityBlock
implements IWireableBlock {
    public static final MapCodec<SightSensorBlock> CODEC = SightSensorBlock.simpleCodec(SightSensorBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public SightSensorBlock(BlockBehaviour.Properties settings) {
        super(settings.noOcclusion().emissiveRendering(CDBlocks::always).lightLevel(state -> (Boolean)state.getValue((Property)POWERED) != false ? 4 : 0));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SightSensorBlockEntity(pos, state);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWER, POWERED});
    }

    @Override
    public int activity(BlockPos pos, Level world) {
        return (Integer)world.getBlockState(pos).getValue((Property)POWER);
    }

    @Override
    public boolean acceptWireTo(IWireableBlock.WireRecipient type, BlockPos target, BlockPos pos, Level world) {
        return false;
    }

    @Override
    public IWireableBlock.WireRecipient type() {
        return IWireableBlock.WireRecipient.SENSOR;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> validateTicker(BlockEntityType<A> given, BlockEntityType<E> expected, BlockEntityTicker<? super E> ticker) {
        return expected == given ? ticker : null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return SightSensorBlockEntity.getTicker(world, state, type);
    }
}

