/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block;

import com.lying.block.IWireableBlock;
import com.lying.block.entity.SoundSensorBlockEntity;
import com.lying.init.CDBlockEntityTypes;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SoundSensorBlock
extends BaseEntityBlock
implements IWireableBlock {
    public static final MapCodec<SoundSensorBlock> CODEC = SoundSensorBlock.simpleCodec(SoundSensorBlock::new);
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final EnumProperty<SculkSensorPhase> PHASE = BlockStateProperties.SCULK_SENSOR_PHASE;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    protected static final VoxelShape UP_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape DOWN_SHAPE = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SoundSensorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.UP)).setValue(PHASE, (Comparable)SculkSensorPhase.INACTIVE)).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SoundSensorBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PHASE, POWER});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue(FACING)) {
            default: {
                return UP_SHAPE;
            }
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case WEST: 
        }
        return WEST_SHAPE;
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> validateTicker(BlockEntityType<A> given, BlockEntityType<E> expected, BlockEntityTicker<? super E> ticker) {
        return expected == given ? ticker : null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return !world.isClientSide ? SoundSensorBlock.validateTicker(type, (BlockEntityType)CDBlockEntityTypes.SOUND_SENSOR.get(), (worldx, pos, statex, blockEntity) -> VibrationSystem.Ticker.tick((Level)worldx, (VibrationSystem.Data)blockEntity.getVibrationData(), (VibrationSystem.User)blockEntity.getVibrationUser())) : null;
    }

    @Override
    public IWireableBlock.WireRecipient type() {
        return IWireableBlock.WireRecipient.SENSOR;
    }

    @Override
    public boolean acceptWireTo(IWireableBlock.WireRecipient type, BlockPos target, BlockPos pos, Level world) {
        return false;
    }

    @Override
    public int activity(BlockPos pos, Level world) {
        return world.getBlockState(pos).getValue(PHASE) == SculkSensorPhase.ACTIVE ? 15 : 0;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getClickedFace());
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        switch ((SculkSensorPhase)state.getValue(PHASE)) {
            case COOLDOWN: {
                world.setBlock(pos, (BlockState)((BlockState)state.setValue(PHASE, (Comparable)SculkSensorPhase.INACTIVE)).setValue((Property)POWER, (Comparable)Integer.valueOf(0)), 3);
                world.playSound(null, pos, SoundEvents.SCULK_CLICKING_STOP, SoundSource.BLOCKS, 1.0f, world.random.nextFloat() * 0.2f + 0.8f);
                break;
            }
            default: {
                world.setBlock(pos, (BlockState)state.setValue(PHASE, (Comparable)SculkSensorPhase.COOLDOWN), 3);
                world.scheduleTick(pos, state.getBlock(), 10);
            }
        }
    }

    @Override
    public void trigger(BlockPos pos, Level world) {
        BlockState state = world.getBlockState(pos);
        world.setBlockAndUpdate(pos, (BlockState)state.setValue(PHASE, (Comparable)SculkSensorPhase.ACTIVE));
        world.scheduleTick(pos, state.getBlock(), 30);
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.SCULK_CLICKING, SoundSource.BLOCKS, 1.0f, world.random.nextFloat() * 0.2f + 0.8f);
    }
}

