/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block;

import com.lying.block.AbstractTrapActorBlock;
import com.lying.block.IWireableBlock;
import com.lying.block.RedstoneActorBlock;
import com.lying.block.entity.SwingingBladeBlockEntity;
import com.lying.init.CDBlockEntityTypes;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SwingingBladeBlock
extends AbstractTrapActorBlock {
    public static final MapCodec<SwingingBladeBlock> CODEC = RedstoneActorBlock.simpleCodec(SwingingBladeBlock::new);
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)3.0, (double)3.0, (double)8.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)3.0, (double)3.0, (double)8.0, (double)13.0, (double)13.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)8.0);
    protected static final VoxelShape WEST_SHAPE = Block.box((double)8.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final VoxelShape UP_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    protected static final VoxelShape DOWN_SHAPE = Block.box((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public SwingingBladeBlock(BlockBehaviour.Properties settings) {
        super(settings.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.UP)).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AXIS, POWERED});
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SwingingBladeBlockEntity(pos, state);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue(FACING)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case DOWN: {
                return DOWN_SHAPE;
            }
        }
        return UP_SHAPE;
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> validateTicker(BlockEntityType<A> given, BlockEntityType<E> expected, BlockEntityTicker<? super E> ticker) {
        return expected == given ? ticker : null;
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return SwingingBladeBlockEntity.getTicker(world, state, type);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction.Axis look = ctx.getNearestLookingDirection().getAxis();
        Direction face = ctx.getClickedFace();
        if (face.getAxis() == look) {
            switch (look) {
                case X: {
                    look = Direction.Axis.Z;
                    break;
                }
                case Y: 
                case Z: {
                    look = Direction.Axis.X;
                }
            }
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)face)).setValue(AXIS, (Comparable)look);
    }

    @Override
    public int wireCount(BlockPos pos, Level world) {
        return ((SwingingBladeBlockEntity)((Object)world.getBlockEntity(pos, (BlockEntityType)CDBlockEntityTypes.SWINGING_BLADE.get()).get())).wireCount();
    }

    @Override
    public boolean acceptWireTo(IWireableBlock.WireRecipient type, BlockPos target, BlockPos pos, Level world) {
        return ((SwingingBladeBlockEntity)((Object)world.getBlockEntity(pos, (BlockEntityType)CDBlockEntityTypes.SWINGING_BLADE.get()).get())).processWireConnection(target, type);
    }

    @Override
    public void clearWires(BlockPos pos, Level world) {
        ((SwingingBladeBlockEntity)((Object)world.getBlockEntity(pos, (BlockEntityType)CDBlockEntityTypes.SWINGING_BLADE.get()).get())).reset();
    }

    @Override
    public void activate(BlockPos pos, Level world) {
        world.setBlock(pos, (BlockState)world.getBlockState(pos).setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
    }

    @Override
    public void deactivate(BlockPos pos, Level world) {
        world.setBlock(pos, (BlockState)world.getBlockState(pos).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
    }
}

