/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block.entity;

import com.lying.block.ProximitySensorBlock;
import com.lying.init.CDBlockEntityTypes;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ProximitySensorBlockEntity
extends BlockEntity {
    private static final Predicate<Entity> PREDICATE = EntitySelector.NO_SPECTATORS;
    private double searchRange = 8.0;

    public ProximitySensorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CDBlockEntityTypes.PROXIMITY_SENSOR.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putDouble("Range", this.searchRange);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.searchRange = nbt.getDouble("Range");
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return type != CDBlockEntityTypes.PROXIMITY_SENSOR.get() ? null : ProximitySensorBlock.validateTicker(type, (BlockEntityType)CDBlockEntityTypes.PROXIMITY_SENSOR.get(), world.isClientSide() ? ProximitySensorBlockEntity::tickClient : ProximitySensorBlockEntity::tickServer);
    }

    public static <T extends BlockEntity> void tickClient(Level world, BlockPos pos, BlockState state, ProximitySensorBlockEntity tile) {
    }

    public static <T extends BlockEntity> void tickServer(Level world, BlockPos pos, BlockState state, ProximitySensorBlockEntity tile) {
        Optional<Double> closest = ((ServerLevel)world).players().stream().filter(p -> tile.distTo((Player)p) <= tile.searchRange).filter(PREDICATE).map(tile::distTo).sorted().findFirst();
        closest.ifPresentOrElse(p -> ProximitySensorBlock.setPower((int)Mth.clamp((double)(15.0 - Math.floor(p)), (double)0.0, (double)15.0), pos, world), () -> ProximitySensorBlock.setPower(0, pos, world));
    }

    public Vec3 vecPos() {
        return new Vec3((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()).add(0.5);
    }

    public double distTo(Player player) {
        return this.vecPos().distanceTo(player.position());
    }
}

