/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block.entity;

import com.lying.block.SightSensorBlock;
import com.lying.init.CDBlockEntityTypes;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class SightSensorBlockEntity
extends BlockEntity {
    public static final Predicate<Entity> IS_VISIBLE = EntitySelector.NO_SPECTATORS.and(e -> !e.isInvisible());
    protected double sightRange = 8.0;
    protected double sightRadius = 4.0;
    private Optional<UUID> lookTargetPlayer = Optional.empty();
    private Vec3 lookVec = new Vec3(0.0, 0.0, -1.0);
    private int tickCount = 0;
    public Vec3 clientLookVec = new Vec3(0.0, 0.0, -1.0);

    public SightSensorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CDBlockEntityTypes.SIGHT_SENSOR.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putDouble("Range", this.sightRange);
        nbt.putDouble("Radius", this.sightRadius);
        this.lookTargetPlayer.ifPresent(id -> nbt.putUUID("Target", id));
        nbt.putDouble("LookX", this.lookVec.x);
        nbt.putDouble("LookY", this.lookVec.y);
        nbt.putDouble("LookZ", this.lookVec.z);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.sightRange = Math.max(1.0, nbt.getDouble("Range"));
        this.sightRadius = Math.max(0.5, nbt.contains("Radius") ? nbt.getDouble("Radius") : this.sightRange * 0.5);
        this.lookTargetPlayer = nbt.contains("Target") ? Optional.of(nbt.getUUID("Target")) : Optional.empty();
        this.lookVec = new Vec3(nbt.getDouble("LookX"), nbt.getDouble("LookY"), nbt.getDouble("LookZ")).normalize();
    }

    public Vec3 currentLook() {
        return this.lookVec;
    }

    public Optional<UUID> currentTarget() {
        return this.lookTargetPlayer;
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return type != CDBlockEntityTypes.SIGHT_SENSOR.get() ? null : SightSensorBlock.validateTicker(type, (BlockEntityType)CDBlockEntityTypes.SIGHT_SENSOR.get(), world.isClientSide() ? SightSensorBlockEntity::tickClient : SightSensorBlockEntity::tickServer);
    }

    public static <T extends BlockEntity> void tickClient(Level world, BlockPos pos, BlockState state, SightSensorBlockEntity tile) {
        Player player;
        Vec3 look = tile.currentLook();
        double adjustRate = 0.1;
        if (tile.currentTarget().isPresent() && (player = world.getPlayerByUUID(tile.currentTarget().get())) != null) {
            look = player.getEyePosition().subtract(tile.getEyePos()).normalize();
            adjustRate = 0.5;
        }
        tile.clientLookVec = tile.clientLookVec.add(look.subtract(tile.clientLookVec).scale(adjustRate));
    }

    public static <T extends BlockEntity> void tickServer(Level world, BlockPos pos, BlockState state, SightSensorBlockEntity tile) {
        if (tile.tickCount++ % SightSensorBlockEntity.updateRate(tile) > 0) {
            return;
        }
        if (tile.lookTargetPlayer.isEmpty()) {
            Vec3 lookVec = tile.lookVec;
            Optional<ServerPlayer> newTarget = ((ServerLevel)world).players().stream().filter(IS_VISIBLE).filter(tile::isInViewCone).filter(p -> SightSensorBlockEntity.canEyeSeePlayer(tile, (Player)p, world)).sorted((a, b) -> {
                double distB;
                double distA = tile.distanceFromLook(a.getEyePosition());
                return distA < (distB = tile.distanceFromLook(b.getEyePosition())) ? -1 : (distA > distB ? 1 : 0);
            }).findFirst();
            newTarget.ifPresentOrElse(p -> {
                tile.startTracking((Player)p);
                tile.setChanged();
            }, () -> {
                RandomSource rand = world.getRandom();
                tile.lookVec = lookVec.add(new Vec3(rand.nextDouble() - 0.5, rand.nextDouble() - 0.5, rand.nextDouble() - 0.5)).normalize();
                tile.lookVec = new Vec3(tile.lookVec.x, Mth.clamp((double)tile.lookVec.y, (double)-0.3, (double)0.3), tile.lookVec.z).normalize();
                tile.setChanged();
            });
        } else if (tile.lookTargetPlayer.isPresent()) {
            Player player = world.getPlayerByUUID(tile.lookTargetPlayer.get());
            if (player == null) {
                tile.clearTracking();
                tile.setChanged();
                return;
            }
            if (player != null && IS_VISIBLE.test((Entity)player) && SightSensorBlockEntity.canEyeSeePlayer(tile, player, world)) {
                int charge = (Integer)tile.getBlockState().getValue((Property)SightSensorBlock.POWER);
                if (charge < 15) {
                    world.setBlock(tile.getBlockPos(), (BlockState)state.setValue((Property)SightSensorBlock.POWER, (Comparable)Integer.valueOf(++charge)), 3);
                }
            } else {
                tile.stopTracking(player);
                tile.setChanged();
            }
        }
    }

    protected void startTracking(Player player) {
        this.lookTargetPlayer = Optional.of(player.getUUID());
        this.updateBlock(1);
    }

    protected void stopTracking(Player player) {
        if (this.lookTargetPlayer.isEmpty() || !this.lookTargetPlayer.get().equals(player.getUUID())) {
            return;
        }
        this.lookTargetPlayer = Optional.empty();
        this.lookVec = player.getEyePosition().subtract(this.getEyePos()).normalize();
        this.tickCount = 0;
        this.updateBlock(0);
    }

    protected void clearTracking() {
        this.lookTargetPlayer = Optional.empty();
        this.lookVec = new Vec3(0.0, 0.0, -1.0);
        this.updateBlock(0);
    }

    protected void updateBlock(int power) {
        if (power == (Integer)this.getBlockState().getValue((Property)SightSensorBlock.POWER)) {
            return;
        }
        BlockState state = (BlockState)((BlockState)this.getBlockState().setValue((Property)SightSensorBlock.POWER, (Comparable)Integer.valueOf(power))).setValue((Property)SightSensorBlock.POWERED, (Comparable)Boolean.valueOf(power > 0));
        this.level.setBlock(this.getBlockPos(), state, 3);
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), state, 3);
    }

    public Vec3 getEyePos() {
        BlockPos tilePos = this.getBlockPos();
        return new Vec3((double)tilePos.getX(), (double)tilePos.getY(), (double)tilePos.getZ()).add(0.5);
    }

    public double distanceFromLook(Vec3 p) {
        double distToP = this.getEyePos().distanceTo(p);
        Vec3 conePoint = this.getEyePos().add(this.lookVec.scale(distToP));
        return p.distanceTo(conePoint);
    }

    protected boolean isInViewCone(Player player) {
        double distFromEye = this.getEyePos().distanceTo(player.getEyePosition());
        double radiusAtDist = distFromEye / this.sightRange * this.sightRadius;
        return distFromEye <= this.sightRange && this.distanceFromLook(player.getEyePosition()) < radiusAtDist;
    }

    protected static boolean canEyeSeePlayer(SightSensorBlockEntity eye, Player player, Level world) {
        if (eye.getEyePos().distanceTo(player.getEyePosition()) > eye.sightRange) {
            return false;
        }
        BlockHitResult trace = world.clip(new ClipContext(player.getEyePosition(), eye.getEyePos(), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return trace.getType() == HitResult.Type.MISS || trace.getBlockPos().distManhattan((Vec3i)eye.getBlockPos()) == 0;
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public static int updateRate(SightSensorBlockEntity tile) {
        return tile.currentTarget().isPresent() ? 20 : 40;
    }
}

