/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block.entity;

import com.lying.CyclicDungeons;
import com.lying.block.IWireableBlock;
import com.lying.block.SoundSensorBlock;
import com.lying.init.CDBlockEntityTypes;
import com.lying.init.CDBlocks;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.jetbrains.annotations.Nullable;

public class SoundSensorBlockEntity
extends BlockEntity
implements GameEventListener.Provider<VibrationSystem.Listener>,
VibrationSystem {
    private final VibrationSystem.Listener listener = new VibrationSystem.Listener((VibrationSystem)this);
    private VibrationSystem.Data listenerData = new VibrationSystem.Data();
    private int lastFrequency;

    public SoundSensorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CDBlockEntityTypes.SOUND_SENSOR.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("last_vibration_frequency", this.lastFrequency);
        RegistryOps registryOps = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        VibrationSystem.Data.CODEC.encodeStart((DynamicOps)registryOps, (Object)this.listenerData).resultOrPartial(string -> CyclicDungeons.LOGGER.error("Failed to encode vibration listener for Sound Sensor: '{}'", string)).ifPresent(listenerNbt -> nbt.put("listener", listenerNbt));
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.lastFrequency = nbt.getInt("last_vibration_frequency");
        RegistryOps registryOps = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (nbt.contains("listener", 10)) {
            VibrationSystem.Data.CODEC.parse((DynamicOps)registryOps, (Object)nbt.getCompound("listener")).resultOrPartial(string -> CyclicDungeons.LOGGER.error("Failed to parse vibration listener for Sound Sensor: '{}'", string)).ifPresent(listener -> {
                this.listenerData = listener;
            });
        }
    }

    public VibrationSystem.Listener getEventListener() {
        return this.listener;
    }

    public VibrationSystem.Data getVibrationData() {
        return this.listenerData;
    }

    public VibrationSystem.User getVibrationUser() {
        return new VibrationCallback(this.getBlockPos());
    }

    protected class VibrationCallback
    implements VibrationSystem.User {
        protected final BlockPos pos;
        private final PositionSource positionSource;

        public VibrationCallback(BlockPos pos) {
            this.pos = pos;
            this.positionSource = new BlockPositionSource(pos);
        }

        public int getListenerRadius() {
            return 8;
        }

        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        public boolean canTriggerAvoidVibration() {
            return true;
        }

        public boolean canReceiveVibration(ServerLevel world, BlockPos pos, Holder<GameEvent> event, @Nullable GameEvent.Context emitter) {
            return !pos.equals((Object)this.pos) || !event.is((Holder)GameEvent.BLOCK_DESTROY) && !event.is((Holder)GameEvent.BLOCK_PLACE) ? SoundSensorBlockEntity.this.getBlockState().getValue(SoundSensorBlock.PHASE) == SculkSensorPhase.INACTIVE : false;
        }

        public void onReceiveVibration(ServerLevel world, BlockPos pos, Holder<GameEvent> event, @Nullable Entity sourceEntity, @Nullable Entity entity, float distance) {
            BlockState blockState = SoundSensorBlockEntity.this.getBlockState();
            if (blockState.getBlock() == CDBlocks.SENSOR_SOUND.get() && blockState.getValue(SoundSensorBlock.PHASE) == SculkSensorPhase.INACTIVE) {
                SoundSensorBlockEntity.this.lastFrequency = VibrationSystem.getGameEventFrequency(event);
                int i = VibrationSystem.getRedstoneStrengthForDistance((float)distance, (int)this.getListenerRadius());
                IWireableBlock.getWireable(this.pos, (Level)world).trigger(this.pos, (Level)world);
                world.setBlockAndUpdate(this.pos, (BlockState)world.getBlockState(this.pos).setValue((Property)SoundSensorBlock.POWER, (Comparable)Integer.valueOf(i)));
            }
        }

        public void onDataChanged() {
            SoundSensorBlockEntity.this.setChanged();
        }

        public boolean requiresAdjacentChunksToBeTicking() {
            return true;
        }
    }
}

