/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block.entity;

import com.google.common.collect.Lists;
import com.lying.block.IWireableBlock;
import com.lying.block.SwingingBladeBlock;
import com.lying.block.entity.TrapActorBlockEntity;
import com.lying.init.CDBlockEntityTypes;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SwingingBladeBlockEntity
extends TrapActorBlockEntity {
    private static final double PIVOT_OFFSET = 0.1875;
    private static final double BLADE_INNER = 1.5;
    private static final double BLADE_OUTER = 2.8;
    private static final float BLADE_ARC = (float)Math.toRadians(4.0);
    private int swingTime = 20;
    private float swingPosition = -1.0f;
    private float swingTarget = -1.0f;
    private boolean prevPower = false;
    public float clientSwingPosition = 0.0f;

    public SwingingBladeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CDBlockEntityTypes.SWINGING_BLADE.get(), pos, state);
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("Speed", this.swingTime);
        nbt.putFloat("Swing", this.swingPosition());
        nbt.putFloat("SwingTarget", this.swingTarget);
        nbt.putBoolean("PrevPower", this.prevPower);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.swingTime = nbt.getInt("Speed");
        this.swingPosition = nbt.getFloat("Swing");
        this.swingTarget = nbt.getFloat("SwingTarget");
        this.prevPower = nbt.getBoolean("PrevPower");
    }

    public float swingPosition() {
        return Mth.clamp((float)this.swingPosition, (float)-1.0f, (float)1.0f);
    }

    public boolean swingComplete() {
        return this.swingPosition() == this.swingTarget;
    }

    @Override
    public boolean processWireConnection(BlockPos pos, IWireableBlock.WireRecipient type) {
        if (type != IWireableBlock.WireRecipient.ACTOR) {
            this.addWire(pos, type);
        }
        return type != IWireableBlock.WireRecipient.ACTOR;
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return type != CDBlockEntityTypes.SWINGING_BLADE.get() ? null : SwingingBladeBlock.validateTicker(type, (BlockEntityType)CDBlockEntityTypes.SWINGING_BLADE.get(), world.isClientSide() ? SwingingBladeBlockEntity::tickClient : SwingingBladeBlockEntity::tickServer);
    }

    public static <T extends BlockEntity> void tickClient(Level world, BlockPos pos, BlockState state, SwingingBladeBlockEntity tile) {
        TrapActorBlockEntity.tickClient(world, pos, state, tile);
        if (tile.clientSwingPosition != tile.swingPosition()) {
            tile.clientSwingPosition += (tile.swingPosition() - tile.clientSwingPosition) * 0.9f;
        }
        if (tile.swingComplete() || world.getRandom().nextBoolean()) {
            return;
        }
        Vec3 pivot = SwingingBladeBlockEntity.getPivotPoint(pos, (Direction)state.getValue(SwingingBladeBlock.FACING));
        Vec3 centre = SwingingBladeBlockEntity.getBladeOffset(state, (float)Math.toRadians(90.0 * (double)tile.clientSwingPosition));
        Vec3 outer = pivot.add(centre.scale(2.15));
        world.addParticle((ParticleOptions)ParticleTypes.CRIT, outer.x, outer.y, outer.z, 0.0, 0.0, 0.0);
    }

    public static <T extends BlockEntity> void tickServer(Level world, BlockPos pos, BlockState state, SwingingBladeBlockEntity tile) {
        TrapActorBlockEntity.tickServer(world, pos, state, tile);
        boolean dirty = false;
        boolean power = (Boolean)state.getValue((Property)SwingingBladeBlock.POWERED);
        if (!tile.swingComplete()) {
            float delta = Math.signum(tile.swingTarget - tile.swingPosition());
            tile.swingPosition += 2.0f / (float)tile.swingTime * delta;
            dirty = true;
        } else if (power && !tile.prevPower) {
            tile.switchSwing();
        }
        if (power != tile.prevPower) {
            tile.prevPower = power;
            dirty = true;
        }
        if (dirty) {
            tile.setChanged();
        }
        Direction facing = (Direction)state.getValue(SwingingBladeBlock.FACING);
        Vec3 pivot = SwingingBladeBlockEntity.getPivotPoint(pos, facing);
        float bladeAngle = (float)tile.getBladeAngle();
        ArrayList hits = Lists.newArrayList();
        for (Vec3 point : new Vec3[]{SwingingBladeBlockEntity.getBladeOffset(state, bladeAngle + BLADE_ARC), SwingingBladeBlockEntity.getBladeOffset(state, bladeAngle), SwingingBladeBlockEntity.getBladeOffset(state, bladeAngle - BLADE_ARC)}) {
            LivingEntity entity;
            Vec3 outer;
            Vec3 inner = pivot.add(point.scale(1.5));
            EntityHitResult trace = ProjectileUtil.getEntityHitResult((Level)world, null, (Vec3)inner, (Vec3)(outer = pivot.add(point.scale(2.8))), (AABB)new AABB(inner, outer), (Predicate)EntitySelector.NO_CREATIVE_OR_SPECTATOR);
            if (trace == null || trace.getType() != HitResult.Type.ENTITY || !(trace.getEntity() instanceof LivingEntity) || hits.contains(entity = (LivingEntity)trace.getEntity())) continue;
            hits.add(entity);
        }
        hits.forEach(tile::hitEntity);
    }

    protected static Vec3 getPivotPoint(BlockPos pos, Direction facing) {
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(0.5).add((double)facing.getOpposite().getStepX() * 0.1875, (double)facing.getOpposite().getStepY() * 0.1875, (double)facing.getOpposite().getStepZ() * 0.1875);
    }

    protected double getBladeAngle() {
        return Math.toRadians(90.0 * (double)this.swingPosition);
    }

    protected static Vec3 getBladeOffset(BlockState state, float angle) {
        Direction facing = (Direction)state.getValue(SwingingBladeBlock.FACING);
        Direction.Axis axis = (Direction.Axis)state.getValue(SwingingBladeBlock.AXIS);
        Vec3 forward = new Vec3((double)facing.getStepX(), (double)facing.getStepY(), (double)facing.getStepZ());
        if (facing.getAxis() == axis) {
            return forward;
        }
        switch (facing.getAxis()) {
            case X: {
                if (axis == Direction.Axis.Y) {
                    return forward.zRot(angle * (float)(facing == Direction.EAST ? 1 : -1));
                }
                return forward.yRot(angle);
            }
            case Y: {
                if (axis == Direction.Axis.X) {
                    return forward.zRot(angle * (float)(facing == Direction.UP ? 1 : -1));
                }
                return forward.xRot(-angle);
            }
            case Z: {
                if (axis == Direction.Axis.Y) {
                    return forward.xRot(angle * (float)(facing == Direction.NORTH ? 1 : -1));
                }
                return forward.yRot(angle * (float)(facing == Direction.NORTH ? -1 : 1));
            }
        }
        return forward;
    }

    public void hitEntity(LivingEntity entity) {
        if (!entity.hurtServer((ServerLevel)this.getLevel(), this.getLevel().damageSources().generic(), 6.0f)) {
            return;
        }
    }

    public void switchSwing() {
        this.swingTarget = this.swingTarget == 1.0f ? -1.0f : 1.0f;
        this.setChanged();
    }
}

