/*
 * Decompiled with CFR 0.152.
 */
package com.lying.blueprint;

import com.google.common.collect.Lists;
import com.lying.blueprint.BlueprintOrganiser;
import com.lying.blueprint.BlueprintPassage;
import com.lying.blueprint.BlueprintPather;
import com.lying.blueprint.BlueprintRoom;
import com.lying.grammar.GrammarPhrase;
import com.lying.grammar.GrammarRoom;
import com.lying.grammar.GrammarTerm;
import com.lying.grammar.RoomMetadata;
import com.lying.grid.BlueprintTileGrid;
import com.lying.grid.GraphTileGrid;
import com.lying.grid.GridTile;
import com.lying.init.CDLoggers;
import com.lying.init.CDTerms;
import com.lying.init.CDTiles;
import com.lying.utility.DebugLogger;
import com.lying.worldgen.Tile;
import com.lying.worldgen.TileGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Blueprint
extends ArrayList<BlueprintRoom> {
    public static final DebugLogger LOGGER = CDLoggers.WORLDGEN;
    public static final int ROOM_TILE_HEIGHT = 4;
    public static final int ROOM_HEIGHT = 8;
    public static final BlockState[] SHELL_PALETTES = new BlockState[]{Blocks.DEEPSLATE_BRICKS.defaultBlockState(), Blocks.CRACKED_DEEPSLATE_BRICKS.defaultBlockState(), Blocks.DEEPSLATE_TILES.defaultBlockState(), Blocks.CRACKED_DEEPSLATE_TILES.defaultBlockState()};
    protected int maxDepth = 0;
    protected Map<Integer, List<BlueprintRoom>> byDepth = new HashMap<Integer, List<BlueprintRoom>>();
    protected List<BlueprintPassage> passageCache = Lists.newArrayList();
    private List<BlueprintRoom> criticalPath = Lists.newArrayList();

    public static Blueprint fromGraph(GrammarPhrase graphIn) {
        Blueprint graph = new Blueprint();
        graphIn.getStart().ifPresent(r -> Blueprint.addNodeToBlueprint(r, null, graph, graphIn));
        return graph;
    }

    private static BlueprintRoom addNodeToBlueprint(GrammarRoom room, @Nullable BlueprintRoom parent, Blueprint graph, GrammarPhrase graphIn) {
        BlueprintRoom node = new BlueprintRoom(room.uuid(), room.metadata(), room.getChildLinks(), room.getParentLinks());
        graph.add(node);
        if (room.hasLinks()) {
            room.getChildRooms(graphIn).forEach((? super T r) -> Blueprint.addNodeToBlueprint(r, parent, graph, graphIn));
        }
        graph.clearPassageCache();
        return node;
    }

    @Override
    public Blueprint clone() {
        Blueprint clone = new Blueprint();
        this.stream().map(BlueprintRoom::clone).forEach(clone::add);
        return clone;
    }

    public Optional<BlueprintRoom> start() {
        return this.stream().filter(n -> n.metadata().is(CDTerms.START.get())).findFirst();
    }

    public Optional<BlueprintRoom> end() {
        return this.stream().filter(n -> n.metadata().is(CDTerms.END.get())).findFirst();
    }

    @Override
    public boolean add(BlueprintRoom node) {
        boolean result = super.add(node);
        if (result) {
            node.attachToBlueprint(this);
            this.maxDepth = 0;
            for (BlueprintRoom n2 : this) {
                if (n2.metadata().depth() <= this.maxDepth) continue;
                this.maxDepth = n2.metadata().depth();
            }
            this.byDepth.clear();
            for (int i = 0; i <= this.maxDepth; ++i) {
                int depth = i;
                this.byDepth.put(i, this.stream().filter(n -> n.metadata().depth() == depth).toList());
            }
        }
        return result;
    }

    public Optional<BlueprintRoom> getRoom(UUID id) {
        return this.stream().filter(r -> r.uuid().equals(id)).findFirst();
    }

    public int maxDepth() {
        return this.maxDepth;
    }

    public void updateCriticalPath() {
        this.criticalPath = BlueprintPather.calculateCriticalPath(this);
    }

    public List<BlueprintRoom> getCriticalPath() {
        return this.criticalPath;
    }

    @NotNull
    public List<BlueprintRoom> byDepth(int depth) {
        return this.byDepth.getOrDefault(depth, Lists.newArrayList());
    }

    public boolean hasErrors() {
        return Blueprint.hasErrors(this);
    }

    public static boolean hasErrors(Blueprint chart) {
        return ErrorType.stream().anyMatch(e -> Blueprint.anyErrors(chart, e));
    }

    public static boolean anyErrors(Blueprint chart, ErrorType type) {
        return type.anyExist(chart);
    }

    public static int tallyErrors(Blueprint chart, ErrorType type) {
        return type.tally(chart, -1);
    }

    public boolean build(BlockPos position, ServerLevel world) {
        if (this.isEmpty() || this.hasErrors()) {
            return false;
        }
        long timeMillis = System.currentTimeMillis();
        LOGGER.info(" # Beginning blueprint generation");
        this.buildExteriorShell(position, world);
        this.buildExteriorPaths(position, world);
        this.buildRooms(position, world);
        this.buildEntrance(position, world);
        LOGGER.info(" # Blueprint generation completed, {}ms total", System.currentTimeMillis() - timeMillis);
        return true;
    }

    public void buildExteriorShell(BlockPos position, ServerLevel world) {
        long timeMillis = System.currentTimeMillis();
        LOGGER.info(" # Generating exterior shell");
        ArrayList bounds = Lists.newArrayList();
        this.stream().map(BlueprintRoom::worldBox).forEach(bounds::add);
        this.passages().stream().map(BlueprintPassage::worldBox).map(b -> b.stream().toList()).forEach(bounds::addAll);
        Predicate<BlockPos> isExterior = p -> bounds.stream().noneMatch(b -> b.contains(new Vec3((double)p.getX(), (double)p.getY(), (double)p.getZ()).add(0.5)));
        bounds.stream().map(b -> b.move(position).inflate(1.0)).forEach((? super T b) -> BlockPos.MutableBlockPos.betweenClosed((BlockPos)new BlockPos((int)b.minX, (int)b.minY, (int)b.minZ), (BlockPos)new BlockPos((int)b.maxX - 1, (int)b.minY + 4, (int)b.maxZ - 1)).forEach((? super T p) -> {
            if (isExterior.test((BlockPos)p)) {
                Tile.tryPlace(SHELL_PALETTES[world.random.nextInt(SHELL_PALETTES.length)], p, world);
            }
        }));
        LOGGER.info(" ## Exterior shell completed in {}ms", System.currentTimeMillis() - timeMillis);
    }

    public void buildRooms(BlockPos position, ServerLevel world) {
        long timeMillis = System.currentTimeMillis();
        LOGGER.info(" # Generating rooms");
        List<BlueprintPassage> passages = BlueprintOrganiser.getFinalisedPassages(this);
        int tally = 0;
        for (BlueprintRoom node : this) {
            RoomMetadata meta = node.metadata();
            GrammarTerm type = meta.type();
            LOGGER.info(" # Room {} of {}: {}x{} {}", ++tally, this.size(), meta.size().x(), meta.size().y(), type.registryName().getPath());
            if (type.generate(position, world, node, passages)) {
                LOGGER.info(" ## Finished");
                continue;
            }
            LOGGER.error(" ## Error during room generation");
        }
        LOGGER.info(" ## Rooms completed in {}ms", System.currentTimeMillis() - timeMillis);
    }

    public void buildExteriorPaths(BlockPos position, ServerLevel world) {
        long timeMillis = System.currentTimeMillis();
        LOGGER.info(" # Generating exterior passages");
        BlueprintOrganiser.getFinalisedPassages(this).forEach((? super T p) -> p.generate(position, world));
        LOGGER.info(" ## Passages completed in {}ms", System.currentTimeMillis() - timeMillis);
    }

    public void buildEntrance(BlockPos position, ServerLevel world) {
        GridTile pos;
        BlueprintRoom start = this.stream().filter(r -> r.metadata().type() == CDTerms.START.get()).findFirst().get();
        GridTile tilePos = start.tilePosition();
        for (int i = 0; i < start.metadata().size().y && start.isAdjacent(pos = tilePos.sub(0, i)); ++i) {
            tilePos = pos;
        }
        GraphTileGrid graph = new GraphTileGrid();
        graph.addToVolume(tilePos);
        BlueprintTileGrid grid = BlueprintTileGrid.fromGraphGrid(graph, 2);
        TileGenerator.generate(grid, Map.of(CDTiles.FLOOR_PRISTINE.get(), Float.valueOf(1.0f)), RandomSource.create());
        grid.finalise();
        grid.generate(position, world);
    }

    public List<BlueprintPassage> passages() {
        if (this.passageCache.isEmpty() && this.size() > 1) {
            this.passageCache.addAll(BlueprintOrganiser.getPassages(this));
        }
        return this.passageCache;
    }

    public void clearPassageCache() {
        this.passageCache.clear();
    }

    public static void tryPlaceAt(BlockState state, BlockPos pos, ServerLevel world) {
        BlockState stateAt = world.getBlockState(pos);
        if (!stateAt.is(BlockTags.WITHER_IMMUNE)) {
            world.setBlockAndUpdate(pos, state);
        }
    }

    public static List<BlueprintPassage> getPassagesOf(BlueprintRoom room, Blueprint chart) {
        return chart.passages().stream().filter(p -> p.isTerminus(room)).toList();
    }

    public static enum ErrorType {
        COLLISION((chart, limit) -> {
            int tally = 0;
            for (BlueprintRoom room : chart) {
                if (!chart.stream().filter(r -> !r.equals(room)).anyMatch(room::intersects) || ++tally < limit || limit <= 0) continue;
                return tally;
            }
            return tally;
        }),
        INTERSECTION((chart, limit) -> {
            int tally = 0;
            List<BlueprintPassage> paths = BlueprintOrganiser.getFinalisedPassages(chart);
            for (BlueprintRoom room : chart) {
                List<GridTile> roomTiles = room.tiles();
                List<BlueprintPassage> passages = paths.stream().filter(p -> !p.isTerminus(room)).toList();
                if (!passages.stream().anyMatch(p -> {
                    List<GridTile> pathTiles = p.tiles();
                    return pathTiles.stream().anyMatch(t -> roomTiles.stream().anyMatch(t::isAdjacentTo));
                }) || ++tally < limit || limit <= 0) continue;
                return tally;
            }
            return tally;
        }),
        TUNNEL((chart, limit) -> {
            int tally = 0;
            for (BlueprintPassage path : BlueprintOrganiser.getFinalisedPassages(chart)) {
                path.exclude(path.parent().tileBounds());
                path.children().stream().map(BlueprintRoom::tileBounds).forEach(path::exclude);
                if (!path.intersectsOtherPassages((Blueprint)chart) || ++tally < limit || limit <= 0) continue;
                return tally;
            }
            return tally;
        });

        private final BiFunction<Blueprint, Integer, Integer> tallyFunc;

        public static Stream<ErrorType> stream() {
            return List.of(ErrorType.values()).stream();
        }

        private ErrorType(BiFunction<Blueprint, Integer, Integer> funcIn) {
            this.tallyFunc = funcIn;
        }

        public boolean anyExist(Blueprint chart) {
            return this.tally(chart, 1) == 1;
        }

        public int tally(Blueprint chart, int limit) {
            return this.tallyFunc.apply(chart, limit);
        }
    }
}

