/*
 * Decompiled with CFR 0.152.
 */
package com.lying.blueprint;

import com.google.common.collect.Lists;
import com.lying.blueprint.Blueprint;
import com.lying.blueprint.BlueprintPassage;
import com.lying.blueprint.BlueprintRoom;
import com.lying.grid.GridTile;
import com.lying.init.CDLoggers;
import com.lying.utility.AbstractBox2f;
import com.lying.utility.CDUtils;
import com.lying.utility.DebugLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BlueprintOrganiser {
    public static final DebugLogger LOGGER = CDLoggers.PLANAR;
    private static final int GRID_SIZE = 30;

    public static final Comparator<BlueprintRoom> descendantSort(List<BlueprintRoom> chart) {
        return (a, b) -> {
            int desB;
            int desA = a.descendantCount(chart);
            return desA > (desB = b.descendantCount(chart)) ? -1 : (desA < desB ? 1 : 0);
        };
    }

    public final void organise(Blueprint chart, RandomSource rand) {
        LOGGER.info(" # Applying organiser to {}:{} planar graph", chart.size(), chart.maxDepth());
        chart.forEach(n -> n.setPosition(0, 0));
        this.applyLayout(chart, rand);
    }

    public abstract void applyLayout(Blueprint var1, RandomSource var2);

    public static List<AbstractBox2f> getBounds(Collection<BlueprintRoom> chart) {
        return chart.stream().map(BlueprintRoom::tileBounds).toList();
    }

    public static List<BlueprintPassage> getFinalisedPassages(Blueprint chart) {
        List<BlueprintPassage> passages = chart.passages();
        return passages;
    }

    public static List<BlueprintPassage> getPassages(Collection<BlueprintRoom> chart) {
        ArrayList paths = Lists.newArrayList();
        for (BlueprintRoom n : chart) {
            n.getChildren(chart).stream().map(c -> new BlueprintPassage(n, (BlueprintRoom)c)).forEach(paths::add);
        }
        return paths;
    }

    public static List<BlueprintPassage> mergePassages(Collection<BlueprintPassage> pathsIn, Collection<AbstractBox2f> bounds) {
        LOGGER.info(" # Merging entwining paths");
        ArrayList pathsToMerge = Lists.newArrayList();
        pathsToMerge.addAll(pathsIn.stream().map(p -> {
            bounds.forEach(p::exclude);
            return p;
        }).filter(Objects::nonNull).toList());
        ArrayList mergedPaths = Lists.newArrayList();
        while (!pathsToMerge.isEmpty()) {
            BlueprintPassage path = (BlueprintPassage)pathsToMerge.removeFirst();
            List<BlueprintPassage> merge = pathsToMerge.stream().filter(path::canMergeWith).toList();
            if (!merge.isEmpty()) {
                merge.forEach(path::mergeWith);
                bounds.forEach(path::exclude);
            }
            mergedPaths.add(path);
            pathsToMerge.removeAll(merge);
        }
        LOGGER.info(" ## Merging complete: reduced from {} to {}", pathsIn.size(), mergedPaths.size());
        return mergedPaths;
    }

    public static abstract class Grid
    extends BlueprintOrganiser {
        protected abstract GridPosition[] moveSet(GridTile var1);

        @Override
        public void applyLayout(Blueprint chart, RandomSource rand) {
            HashMap<GridTile, BlueprintRoom> gridMap = new HashMap<GridTile, BlueprintRoom>();
            for (int step = 0; step <= chart.maxDepth(); ++step) {
                Grid.organiseByGrid(chart, step, gridMap, this::moveSet, 30, rand);
            }
            if (gridMap.size() != chart.size()) {
                LOGGER.warn("Grid layout size ({}) differs from input blueprint size ({})", gridMap.size(), chart.size());
            }
        }

        private static void organiseByGrid(Blueprint chart, int depth, Map<GridTile, BlueprintRoom> gridMap, Function<GridTile, GridPosition[]> moveSet, int gridSize, RandomSource rand) {
            ArrayList rooms = Lists.newArrayList();
            rooms.addAll(chart.byDepth(depth));
            rooms.sort(Grid.descendantSort(chart));
            for (BlueprintRoom node : rooms) {
                if (gridMap.isEmpty()) {
                    node.setPosition(0, 0);
                    gridMap.put(node.tilePosition(), node);
                    continue;
                }
                if (!node.hasParents()) continue;
                GridTile position = new GridTile(0, 0);
                List<BlueprintRoom> parents = node.getParents(chart);
                if (!parents.isEmpty()) {
                    List<GridTile> options = Grid.getAvailableOptions(parents, node.childrenCount(), moveSet, gridSize, gridMap);
                    if (options.isEmpty()) continue;
                    position = Grid.selectOption(options, parents, chart, rand);
                }
                gridMap.put(position, node.setTilePosition(position));
            }
        }

        private static GridTile selectOption(List<GridTile> options, List<BlueprintRoom> parents, Blueprint chart, RandomSource rand) {
            if (options.size() > 1) {
                ArrayList gPositions = Lists.newArrayList();
                parents.forEach(n -> gPositions.add(n.getParentPosition(chart)));
                if (!gPositions.isEmpty()) {
                    int gX = 0;
                    int gY = 0;
                    for (GridTile gPos : gPositions) {
                        gX += gPos.x;
                        gY += gPos.y;
                    }
                    GridTile gPos = new GridTile(gX /= gPositions.size(), gY /= gPositions.size());
                    double maxDist = -1.0;
                    HashMap<GridTile, Double> distMap = new HashMap<GridTile, Double>();
                    for (GridTile option : options) {
                        double dist = option.distance(gPos);
                        distMap.put(option, dist);
                        if (!(dist > maxDist)) continue;
                        maxDist = dist;
                    }
                    double optimalDist = maxDist;
                    ArrayList weights = Lists.newArrayList();
                    distMap.entrySet().forEach(e -> weights.add(Pair.of((Object)((GridTile)e.getKey()), (Object)Float.valueOf((float)((Double)e.getValue() / optimalDist)))));
                    return (GridTile)CDUtils.selectFromWeightedList(weights, rand.nextFloat());
                }
                return options.get(rand.nextInt(options.size()));
            }
            return options.get(0);
        }

        public static List<GridTile> getAvailableOptions(List<BlueprintRoom> parents, int childTally, Function<GridTile, GridPosition[]> moveSet, int gridSize, Map<GridTile, BlueprintRoom> gridMap) {
            ArrayList options = Lists.newArrayList();
            for (BlueprintRoom parent : parents) {
                Grid.getAvailableOptions(parent.tilePosition(), childTally, moveSet, gridSize, gridMap).stream().filter(p -> !options.contains(p)).forEach(options::add);
            }
            Blueprint posit = new Blueprint();
            gridMap.values().stream().map(BlueprintRoom::clone).forEach(posit::add);
            BlueprintRoom concept = BlueprintRoom.create();
            parents.stream().forEach(p -> posit.stream().filter(pH -> pH.uuid().equals(p.uuid())).forEach(pH -> pH.addChild(concept)));
            posit.add(concept);
            options.removeIf(pos -> {
                concept.setTilePosition((GridTile)pos);
                return Blueprint.hasErrors(posit);
            });
            return options;
        }

        public static List<GridTile> getAvailableOptions(GridTile position, int minExits, Function<GridTile, GridPosition[]> moveSet, int gridSize, Map<GridTile, BlueprintRoom> gridMap) {
            ArrayList options = Lists.newArrayList();
            for (GridPosition offset : moveSet.apply(position)) {
                GridTile neighbour = offset.get(position, gridMap, gridSize);
                if (gridMap.containsKey(neighbour) || neighbour.y < 0 || minExits > 0 && Grid.getAvailableOptions(neighbour, -1, moveSet, gridSize, gridMap).size() <= minExits) continue;
                options.add(neighbour);
            }
            return options;
        }

        @FunctionalInterface
        public static interface GridPosition {
            public GridTile get(GridTile var1, Map<GridTile, BlueprintRoom> var2, int var3);
        }

        public static class Octagonal
        extends Grid {
            public static final GridPosition[] OCT_GRID_A = new GridPosition[]{(p, o, g) -> p.add(g, 0), (p, o, g) -> p.add(-g, 0), (p, o, g) -> p.add(0, g), (p, o, g) -> p.add(0, -g), ScaledGridPosition.of(0.5, 1, 1), ScaledGridPosition.of(0.5, 1, -1), ScaledGridPosition.of(0.5, -1, 1), ScaledGridPosition.of(0.5, -1, -1)};
            public static final GridPosition[] OCT_GRID_B = new GridPosition[]{ScaledGridPosition.of(0.5, 1, 1), ScaledGridPosition.of(0.5, 1, -1), ScaledGridPosition.of(0.5, -1, 1), ScaledGridPosition.of(0.5, -1, -1)};

            public static Octagonal create() {
                return new Octagonal();
            }

            @Override
            protected GridPosition[] moveSet(GridTile position) {
                return position.y % 1 == 0 ? OCT_GRID_A : OCT_GRID_B;
            }
        }

        public static class Square
        extends Grid {
            public static final GridPosition[] QUAD_GRID = new GridPosition[]{(p, o, g) -> p.add(g, 0), (p, o, g) -> p.add(-g, 0), (p, o, g) -> p.add(0, g), (p, o, g) -> p.add(0, -g)};

            public static Square create() {
                return new Square();
            }

            @Override
            protected GridPosition[] moveSet(GridTile position) {
                return QUAD_GRID;
            }
        }

        protected static class ScaledGridPosition
        implements GridPosition {
            private final double scale;
            private final int x;
            private final int y;

            protected ScaledGridPosition(int xIn, int yIn, double scaleIn) {
                this.scale = scaleIn;
                this.x = xIn;
                this.y = yIn;
            }

            public static GridPosition of(double val, int x, int y) {
                return new ScaledGridPosition(x, y, val);
            }

            @Override
            public GridTile get(GridTile position, Map<GridTile, BlueprintRoom> occupancies, int gridSize) {
                int size = (int)((double)gridSize * this.scale);
                return position.add(this.x * size, this.y * size);
            }
        }
    }

    public static class Circular
    extends BlueprintOrganiser {
        public static Circular create() {
            return new Circular();
        }

        @Override
        public void applyLayout(Blueprint chart, RandomSource rand) {
            Comparator<BlueprintRoom> descSort = Circular.descendantSort(chart);
            block0: for (int step = 1; step <= chart.maxDepth(); ++step) {
                ArrayList set = Lists.newArrayList();
                set.addAll(chart.byDepth(step));
                set.sort(descSort);
                int radius = step * 30;
                double circ = 2.0 * (Math.PI * (double)radius);
                int pop = Math.max((int)(circ / 60.0), set.size());
                double rot = Math.toRadians(180.0 / (double)pop);
                double cos = Math.cos(rot);
                double sin = Math.sin(rot);
                GridTile point = new GridTile(radius, 0);
                ArrayList positions = Lists.newArrayList();
                for (int i = 0; i < pop; ++i) {
                    positions.add(point);
                    point = new GridTile((int)((double)point.x * cos - (double)point.y * sin), (int)((double)point.x * sin + (double)point.y * cos));
                }
                for (BlueprintRoom room : set) {
                    if (positions.isEmpty()) continue block0;
                    GridTile parent = room.getParentPosition(chart);
                    positions.sort((a, b) -> {
                        double dB;
                        double dA = a.distance(parent);
                        if (dA == (dB = b.distance(parent))) {
                            int mB;
                            int mA = Math.abs(a.x) + Math.abs(a.y);
                            if (mA == (mB = Math.abs(b.x) + Math.abs(b.y))) {
                                int yB;
                                int yA = Math.abs(a.y);
                                return yA > (yB = Math.abs(b.y)) ? -1 : (yA < yB ? 1 : 0);
                            }
                            return mA < mB ? -1 : (mA > mB ? 1 : 0);
                        }
                        return dA < dB ? -1 : (dA > dB ? 1 : 0);
                    });
                    room.setTilePosition((GridTile)positions.removeFirst());
                }
            }
        }
    }

    public static class Tree
    extends BlueprintOrganiser {
        public static Tree create() {
            return new Tree();
        }

        @Override
        public void applyLayout(Blueprint chart, RandomSource rand) {
            Comparator<BlueprintRoom> descSort = Tree.descendantSort(chart);
            for (int depth = 0; depth <= chart.maxDepth(); ++depth) {
                ArrayList nodes = Lists.newArrayList();
                nodes.addAll(chart.byDepth(depth));
                nodes.sort(descSort);
                int y = depth * 30;
                int rowWidth = (nodes.size() - 1) * 30;
                int x = -rowWidth / 2;
                for (BlueprintRoom node : nodes) {
                    node.setPosition(x, y);
                    x += 30;
                }
            }
        }
    }
}

