/*
 * Decompiled with CFR 0.152.
 */
package com.lying.blueprint;

import com.google.common.collect.Lists;
import com.lying.blueprint.Blueprint;
import com.lying.blueprint.BlueprintPassage;
import com.lying.blueprint.BlueprintRoom;
import com.lying.init.CDLoggers;
import com.lying.utility.DebugLogger;
import com.lying.utility.LineSegment2f;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector2i;

public class BlueprintScruncher {
    public static DebugLogger LOGGER = CDLoggers.PLANAR;

    public static void collapse(Blueprint chart, boolean reverse) {
        int cap = 1000;
        while (BlueprintScruncher.scrunch(chart, reverse) && --cap > 0) {
        }
    }

    public static boolean scrunch(Blueprint chart, boolean reverse) {
        int depth;
        int maxDepth = chart.maxDepth();
        boolean anyMoved = false;
        int inc = (int)Math.signum(depth) * -1;
        for (depth = reverse ? maxDepth : -maxDepth; depth != 0; depth += inc) {
            anyMoved = BlueprintScruncher.tryScrunch(chart.byDepth(Math.abs(depth)), chart) || anyMoved;
        }
        return anyMoved;
    }

    private static boolean tryScrunch(List<BlueprintRoom> nodes, Blueprint chart) {
        boolean anyMoved = false;
        for (BlueprintRoom node : nodes) {
            anyMoved = BlueprintScruncher.tryScrunchNode(node, chart) || anyMoved;
        }
        return anyMoved;
    }

    public static boolean tryScrunchNode(BlueprintRoom node, Blueprint chart) {
        Vec2 direction;
        BlueprintRoom parent = node.getParents(chart).getFirst();
        if (parent == null) {
            return false;
        }
        BlueprintPassage path = new BlueprintPassage(parent, node);
        List<LineSegment2f> lines = path.asLines();
        switch (lines.size()) {
            case 1: {
                LineSegment2f line = lines.getFirst();
                if (line.isStraightLine() && line.manhattanLength() <= 2.0f) {
                    return false;
                }
                direction = line.direction().negated();
                break;
            }
            case 2: {
                direction = (lines.getFirst().length() > lines.getLast().length() ? lines.getFirst() : lines.getLast()).direction().negated();
                break;
            }
            default: {
                direction = lines.get(lines.size() - 2).direction().negated();
            }
        }
        return direction.length() > 2.0f && BlueprintScruncher.tryMoveNodeByWorld(node, chart, direction);
    }

    public static Vector2i vec2fToVec2i(Vec2 vec) {
        return new Vector2i((int)vec.x, (int)vec.y);
    }

    public static boolean tryMoveNodeByWorld(BlueprintRoom node, Blueprint chart, Vec2 direction) {
        Vec2 gridDirection = direction.normalized().scale((float)Math.floor(direction.length() / 2.0f));
        for (float i = gridDirection.length(); i > 0.0f; i -= 1.0f) {
            int y;
            Vec2 point = gridDirection.normalized().scale(i);
            int x = Math.abs(point.x) >= 1.0f ? (int)point.x : (int)Math.signum(point.x);
            int n = y = Math.abs(point.y) >= 1.0f ? (int)point.y : (int)Math.signum(point.y);
            if (!BlueprintScruncher.tryMoveRelative(node, chart, new Vector2i(x, y))) continue;
            return true;
        }
        return false;
    }

    public static boolean tryMoveRelative(BlueprintRoom node, Blueprint chart, Vector2i move) {
        if (move.length() == 0.0) {
            return false;
        }
        if (BlueprintScruncher.tryMove(node, chart, move)) {
            return true;
        }
        if ((double)(Math.abs(move.x) + Math.abs(move.y)) != move.length()) {
            Vector2i onlyX = new Vector2i(move.x, 0);
            Vector2i onlyY = new Vector2i(0, move.y);
            double distX = Math.abs(move.x);
            double distY = Math.abs(move.y);
            Supplier<Boolean> tryX = () -> BlueprintScruncher.tryMove(node, chart, onlyX);
            Supplier<Boolean> tryY = () -> BlueprintScruncher.tryMove(node, chart, onlyY);
            if (distX < distY) {
                return tryX.get() != false ? true : tryY.get();
            }
            return tryY.get() != false ? true : tryX.get();
        }
        return false;
    }

    public static boolean tryMove(BlueprintRoom node, Blueprint chart, Vector2i move) {
        if (move.length() == 0.0) {
            return false;
        }
        Blueprint sim = chart.clone();
        ArrayList simNodes = Lists.newArrayList();
        simNodes.add(sim.getRoom(node.uuid()).get());
        simNodes.addAll(BlueprintScruncher.gatherDescendantsOf((BlueprintRoom)simNodes.getFirst(), sim));
        simNodes.forEach(n -> n.move(move));
        if (sim.hasErrors()) {
            return false;
        }
        node.move(move);
        BlueprintScruncher.gatherDescendantsOf(node, chart).forEach(n -> n.move(move));
        return true;
    }

    public static List<BlueprintRoom> gatherDescendantsOf(BlueprintRoom node, Blueprint chart) {
        ArrayList children = Lists.newArrayList();
        node.getChildren(chart).forEach(child -> {
            if (children.contains(child)) {
                return;
            }
            children.add(child);
            if (child.hasChildren()) {
                List<BlueprintRoom> childRooms = BlueprintScruncher.gatherDescendantsOf(child, chart);
                childRooms.removeIf(children::contains);
                children.addAll(childRooms);
            }
        });
        return children;
    }
}

