/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.renderer.block;

import com.lying.block.entity.SightSensorBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;

public class SightSensorBlockEntityRenderer
implements BlockEntityRenderer<SightSensorBlockEntity> {
    private final BlockRenderDispatcher blockRenderManager;

    public SightSensorBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderManager = ctx.getBlockRenderDispatcher();
    }

    public void render(SightSensorBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        BlockPos tilePos = entity.getBlockPos();
        Vec3 look = entity.clientLookVec;
        matrices.pushPose();
        matrices.translate(0.5, 0.5, 0.5);
        matrices.scale(0.8f, 0.8f, 0.8f);
        matrices.mulPose(Axis.YP.rotation((float)Math.atan2(look.x, look.z)));
        matrices.mulPose(Axis.XP.rotation((float)Math.asin(-look.y)));
        matrices.translate(-0.5, -0.5, -0.5);
        matrices.pushPose();
        this.blockRenderManager.getModelRenderer().tesselateBlock((BlockAndTintGetter)entity.getLevel(), this.blockRenderManager.getBlockModel(entity.getBlockState()), entity.getBlockState(), tilePos, matrices, vertexConsumers.getBuffer(RenderType.solid()), false, RandomSource.create(), 0L, overlay);
        matrices.popPose();
        matrices.popPose();
    }
}

