/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.renderer.block;

import com.lying.block.BladeBlock;
import com.lying.block.SwingingBladeBlock;
import com.lying.block.entity.SwingingBladeBlockEntity;
import com.lying.client.renderer.block.WireableBlockEntityRenderer;
import com.lying.init.CDBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SwingingBladeBlockEntityRenderer
extends WireableBlockEntityRenderer<SwingingBladeBlockEntity> {
    private final BlockRenderDispatcher blockRenderManager;

    public SwingingBladeBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        this.blockRenderManager = ctx.getBlockRenderDispatcher();
    }

    @Override
    public void render(SwingingBladeBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        super.render(entity, tickDelta, matrices, vertexConsumers, light, overlay);
        BlockPos tilePos = entity.getBlockPos();
        BlockState tileState = entity.getBlockState();
        Direction face = (Direction)tileState.getValue(SwingingBladeBlock.FACING);
        Direction.Axis axis = (Direction.Axis)tileState.getValue(SwingingBladeBlock.AXIS);
        matrices.pushPose();
        this.setupInitialRotations(matrices, face, axis);
        this.applySwingRotation(entity.clientSwingPosition, matrices);
        this.renderBlade((ClientLevel)entity.getLevel(), tileState, tilePos, tickDelta, matrices, vertexConsumers, light, overlay);
        matrices.popPose();
    }

    private void setupInitialRotations(PoseStack matrices, Direction face, Direction.Axis axis) {
        matrices.translate(0.5, 0.5, 0.5);
        switch (face) {
            case DOWN: {
                matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
            }
            case UP: {
                if (axis != Direction.Axis.X) break;
                matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case NORTH: {
                if (axis != Direction.Axis.Y) {
                    matrices.mulPose(Axis.ZP.rotationDegrees(90.0f));
                }
                matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
                matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
                if (axis != Direction.Axis.Y) {
                    matrices.mulPose(Axis.ZP.rotationDegrees(90.0f));
                }
                matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case SOUTH: {
                if (axis != Direction.Axis.Y) {
                    matrices.mulPose(Axis.ZP.rotationDegrees(90.0f));
                }
                matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                matrices.mulPose(Axis.YP.rotationDegrees(270.0f));
                if (axis != Direction.Axis.Y) {
                    matrices.mulPose(Axis.ZP.rotationDegrees(90.0f));
                }
                matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
        }
        matrices.translate(-0.5, -0.5, -0.5);
    }

    private void applySwingRotation(float swingPosition, PoseStack matrices) {
        double offsetY = 0.3125;
        matrices.translate(0.5, offsetY, 0.5);
        matrices.mulPose(Axis.XP.rotationDegrees(90.0f * swingPosition));
        matrices.translate(-0.5, -offsetY, -0.5);
    }

    private void renderBlade(ClientLevel world, BlockState state, BlockPos tilePos, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.pushPose();
        this.blockRenderManager.getModelRenderer().tesselateBlock((BlockAndTintGetter)world, this.blockRenderManager.getBlockModel((BlockState)((Block)CDBlocks.BLADE.get()).defaultBlockState().setValue(BladeBlock.PART, (Comparable)((Object)BladeBlock.Part.MOUNT))), state, tilePos, matrices, vertexConsumers.getBuffer(RenderType.solid()), false, RandomSource.create(), 0L, overlay);
        matrices.translate(0.0f, 1.0f, 0.0f);
        this.blockRenderManager.getModelRenderer().tesselateBlock((BlockAndTintGetter)world, this.blockRenderManager.getBlockModel((BlockState)((Block)CDBlocks.BLADE.get()).defaultBlockState().setValue(BladeBlock.PART, (Comparable)((Object)BladeBlock.Part.ARM))), state, tilePos, matrices, vertexConsumers.getBuffer(RenderType.solid()), false, RandomSource.create(), 0L, overlay);
        matrices.translate(0.0f, 1.0f, 0.0f);
        this.blockRenderManager.getModelRenderer().tesselateBlock((BlockAndTintGetter)world, this.blockRenderManager.getBlockModel((BlockState)((Block)CDBlocks.BLADE.get()).defaultBlockState().setValue(BladeBlock.PART, (Comparable)((Object)BladeBlock.Part.BLADE))), state, tilePos, matrices, vertexConsumers.getBuffer(RenderType.solid()), false, RandomSource.create(), 0L, overlay);
        matrices.popPose();
    }
}

