/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grammar;

import com.google.common.collect.Lists;
import com.lying.blueprint.BlueprintPassage;
import com.lying.blueprint.BlueprintRoom;
import com.lying.grammar.GrammarPhrase;
import com.lying.grammar.GrammarRoom;
import com.lying.grammar.TermConditions;
import com.lying.grid.BlueprintTileGrid;
import com.lying.grid.GraphTileGrid;
import com.lying.grid.GridTile;
import com.lying.init.CDLoggers;
import com.lying.init.CDRoomTileSets;
import com.lying.init.CDTerms;
import com.lying.init.CDTiles;
import com.lying.utility.DebugLogger;
import com.lying.worldgen.Tile;
import com.lying.worldgen.TileGenerator;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public abstract class GrammarTerm {
    public static final DebugLogger LOGGER = CDLoggers.WORLDGEN;
    protected static final Codec<GrammarTerm> CODEC = ResourceLocation.CODEC.comapFlatMap(id -> {
        Optional<GrammarTerm> type = CDTerms.get(id);
        if (type.isPresent()) {
            return DataResult.success((Object)type.get());
        }
        return DataResult.error(() -> "Not a recognised type: '" + String.valueOf(id) + "'");
    }, GrammarTerm::registryName);
    private final ResourceLocation registryName;
    private final int colour;
    private final DyeColor color;
    private final int weight;
    private final boolean isReplaceable;
    private final boolean isPlaceable;
    private final boolean isBranchInjector;
    private final TermConditions conditions;
    private final Function<RandomSource, Vector2i> sizeFunc;
    private final Map<Tile, Float> tileSet;

    private GrammarTerm(ResourceLocation idIn, int weightIn, int colourIn, DyeColor colorIn, Function<RandomSource, Vector2i> sizeFuncIn, boolean placeable, boolean replaceable, boolean injectsBranch, TermConditions conditionsIn, Map<Tile, Float> tileSetIn) {
        this.registryName = idIn;
        this.weight = weightIn;
        this.colour = colourIn;
        this.color = colorIn;
        this.sizeFunc = sizeFuncIn;
        this.conditions = conditionsIn;
        this.tileSet = tileSetIn;
        this.isPlaceable = placeable;
        this.isReplaceable = replaceable;
        this.isBranchInjector = injectsBranch;
    }

    public final ResourceLocation registryName() {
        return this.registryName;
    }

    public final int colour() {
        return this.colour;
    }

    public final DyeColor color() {
        return this.color;
    }

    public final int weight() {
        return this.weight;
    }

    public MutableComponent name() {
        return Component.literal((String)this.registryName.getPath());
    }

    public boolean matches(GrammarTerm b) {
        return this.registryName.equals((Object)b.registryName);
    }

    public boolean isReplaceable() {
        return this.isReplaceable;
    }

    public boolean isPlaceable() {
        return this.isPlaceable;
    }

    public boolean isBranchInjector() {
        return this.isBranchInjector;
    }

    public final boolean canBePlaced(GrammarRoom inRoom, @NotNull List<GrammarRoom> previous, @NotNull List<GrammarRoom> next, GrammarPhrase graph) {
        return (!this.isBranchInjector() || inRoom.canAddLink()) && this.conditions.test(this, inRoom, previous, next, graph);
    }

    public boolean generate(BlockPos position, ServerLevel world, BlueprintRoom node, List<BlueprintPassage> passages) {
        BlueprintTileGrid map = BlueprintTileGrid.fromGraphGrid(node.tileGrid(), 4);
        GrammarTerm.preseedDoorways(node, map, passages);
        TileGenerator.generate(map, this.tileSet, world.getRandom());
        map.finalise();
        return map.generate(position, world);
    }

    protected static void preseedDoorways(BlueprintRoom node, BlueprintTileGrid map, List<BlueprintPassage> passages) {
        List<GraphTileGrid> connectingPassages = passages.stream().filter(p -> p.isTerminus(node)).map(BlueprintPassage::asTiles).toList();
        map.getBoundaries(Direction.Plane.HORIZONTAL.stream().toList()).stream().filter(t -> {
            GridTile tile = new GridTile(t.getX(), t.getZ());
            return connectingPassages.stream().anyMatch(g -> g.containsAdjacent(tile));
        }).forEach(t -> map.put(t.atY(1), CDTiles.PASSAGE.get()));
    }

    public void applyTo(GrammarRoom room, GrammarPhrase graph) {
        room.metadata().setType(this);
        this.onApply(room, graph);
    }

    protected abstract void onApply(GrammarRoom var1, GrammarPhrase var2);

    public Vector2i size(RandomSource rand) {
        return this.sizeFunc.apply(rand);
    }

    public static GrammarRoom injectRoom(GrammarRoom room, GrammarPhrase graph) {
        GrammarRoom injected = new GrammarRoom();
        room.getChildLinks().forEach(uuid -> {
            Optional<GrammarRoom> child = graph.get((UUID)uuid);
            if (child.isEmpty()) {
                return;
            }
            injected.linkTo(child.get());
            room.detachFrom(child.get());
        });
        room.linkTo(injected);
        graph.add(injected);
        return injected;
    }

    public static GrammarRoom injectBranch(GrammarRoom room, GrammarPhrase graph) {
        GrammarRoom injected = new GrammarRoom();
        room.linkTo(injected);
        graph.add(injected);
        return injected;
    }

    protected static boolean checkListFor(@Nullable List<GrammarRoom> rooms, GrammarTerm term) {
        return rooms != null && !rooms.isEmpty() && rooms.stream().filter(Objects::nonNull).anyMatch(r -> r.metadata().is(term));
    }

    public static class Builder {
        private final int colour;
        private final DyeColor color;
        private int weight = 1;
        private boolean replaceable = false;
        private boolean placeable = true;
        private boolean afterSelf = true;
        private boolean deadEnds = true;
        private boolean injects = false;
        private int maxPop = -1;
        private int sizeCap = -1;
        private int depthMin = -1;
        private List<Supplier<GrammarTerm>> after = Lists.newArrayList();
        private List<Supplier<GrammarTerm>> before = Lists.newArrayList();
        private List<Supplier<GrammarTerm>> notAfter = Lists.newArrayList();
        private List<Supplier<GrammarTerm>> notBefore = Lists.newArrayList();
        private TermApplyFunc applyFunc = (t, r, g) -> {};
        private Function<RandomSource, Vector2i> sizeFunc = r -> new Vector2i(3 + r.nextInt(4), 3 + r.nextInt(4));
        private Map<Tile, Float> tileSet = CDRoomTileSets.DEFAULT_TILESET;

        private Builder(int colourIn, DyeColor colorIn) {
            this.colour = colourIn;
            this.color = colorIn;
        }

        public static Builder create(int colour, DyeColor color) {
            return new Builder(colour, color);
        }

        public Builder unplaceable() {
            this.placeable = false;
            return this;
        }

        public Builder replaceable() {
            this.replaceable = true;
            return this;
        }

        public Builder injectsBranches() {
            this.injects = true;
            return this;
        }

        public Builder weight(int val) {
            this.weight = val;
            return this;
        }

        public Builder nonconsecutive() {
            this.afterSelf = false;
            return this;
        }

        public Builder afterDepth(int dep) {
            this.depthMin = dep;
            return this;
        }

        public Builder allowDeadEnds(boolean val) {
            this.deadEnds = val;
            return this;
        }

        public Builder popCap(int cap) {
            this.maxPop = cap;
            return this;
        }

        public Builder sizeCap(int cap) {
            this.sizeCap = cap;
            return this;
        }

        public Builder size(Function<RandomSource, Vector2i> func) {
            this.sizeFunc = func;
            return this;
        }

        public Builder size(Vector2i vec) {
            this.sizeFunc = r -> vec;
            return this;
        }

        public Builder onlyAfter(Supplier<GrammarTerm> ... term) {
            for (Supplier<GrammarTerm> termIn : term) {
                this.after.add(termIn);
            }
            return this;
        }

        public Builder neverAfter(Supplier<GrammarTerm> ... term) {
            for (Supplier<GrammarTerm> termIn : term) {
                this.notAfter.add(termIn);
            }
            return this;
        }

        public Builder onlyBefore(Supplier<GrammarTerm> ... term) {
            for (Supplier<GrammarTerm> termIn : term) {
                this.before.add(termIn);
            }
            return this;
        }

        public Builder neverBefore(Supplier<GrammarTerm> ... term) {
            for (Supplier<GrammarTerm> termIn : term) {
                this.notBefore.add(termIn);
            }
            return this;
        }

        public Builder onApply(TermApplyFunc funcIn) {
            this.applyFunc = funcIn;
            return this;
        }

        public Builder withTileSet(Map<Tile, Float> tileSetIn) {
            this.tileSet = tileSetIn;
            return this;
        }

        public GrammarTerm build(ResourceLocation registryName) {
            TermConditions conditions = TermConditions.create().nonconsecutive(this.afterSelf).sizeCap(this.sizeCap).afterDepth(this.depthMin).popCap(this.maxPop).allowDeadEnds(this.deadEnds).onlyAfter(this.after).neverAfter(this.notAfter).onlyBefore(this.before).neverBefore(this.notBefore);
            return new GrammarTerm(registryName, this.weight, this.colour, this.color, this.sizeFunc, this.placeable, this.replaceable, this.injects, conditions, this.tileSet){

                @Override
                public void onApply(GrammarRoom room, GrammarPhrase graph) {
                    applyFunc.apply(this, room, graph);
                }
            };
        }

        @FunctionalInterface
        public static interface TermApplyFunc {
            public void apply(GrammarTerm var1, GrammarRoom var2, GrammarPhrase var3);
        }
    }
}

