/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grid;

import com.google.common.collect.Lists;
import com.lying.init.CDLoggers;
import com.lying.init.CDTiles;
import com.lying.utility.DebugLogger;
import com.lying.worldgen.Tile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTileGrid<T> {
    public static final DebugLogger LOGGER = CDLoggers.WFC;
    public static final Tile BLANK = CDTiles.BLANK.get();
    protected final Map<T, Tile> set = new HashMap<T, Tile>();
    protected final Map<Tile, Integer> tally = new HashMap<Tile, Integer>();
    protected final Map<T, List<Tile>> optionCache = new HashMap<T, List<Tile>>();

    public final int volume() {
        return this.set.size();
    }

    public final boolean isEmpty() {
        return this.set.isEmpty();
    }

    public final AbstractTileGrid<T> addToVolume(T pos) {
        this.setTile(pos, BLANK);
        return this;
    }

    public final AbstractTileGrid<T> addAllToVolume(Collection<T> positions) {
        positions.forEach(this::addToVolume);
        return this;
    }

    public abstract AbstractTileGrid<T> addToVolume(T var1, T var2);

    public final AbstractTileGrid<T> removeFromVolume(T pos) {
        this.set.remove(pos);
        return this;
    }

    public final void grow(Direction direction) {
        this.grow(direction, 1);
    }

    public abstract void grow(Direction var1, int var2);

    public final boolean contains(T pos) {
        return this.set.keySet().stream().anyMatch(pos::equals);
    }

    public abstract boolean containsAdjacent(T var1);

    public final boolean containsOrAdjacent(T pos) {
        return this.contains(pos) || this.containsAdjacent(pos);
    }

    public final Optional<Tile> get(T pos) {
        if (this.contains(pos)) {
            return Optional.of(this.set.get(pos));
        }
        LOGGER.warn("Tried to retrieve position this grid does not recognise");
        return Optional.empty();
    }

    public void put(T pos, @Nullable Tile tile) {
        if (tile == null) {
            LOGGER.warn("Attempted to set null tile into grid");
        } else if (!this.contains(pos)) {
            LOGGER.warn("Attempted to set position outside of grid volume");
            return;
        }
        this.setTile(pos, tile == null ? BLANK : tile);
    }

    private final void setTile(T pos, @NotNull Tile tile) {
        this.get(pos).ifPresent(t -> this.tally.put((Tile)t, this.tallyOf((Tile)t) - 1));
        this.set.put(pos, tile);
        this.tally.put(tile, this.tallyOf(tile) + 1);
    }

    public final Collection<T> contents() {
        return this.set.keySet();
    }

    public final List<T> getBoundaries() {
        return this.getBoundaries(Direction.Plane.HORIZONTAL.stream().toList());
    }

    public abstract List<T> getBoundaries(List<Direction> var1);

    public final boolean hasBlanks() {
        return this.tallyOf(BLANK) > 0;
    }

    public final int tallyOf(Tile tile) {
        return this.tally.getOrDefault(tile, 0);
    }

    public final int tallyMatching(Predicate<Tile> predicate) {
        int val = 0;
        for (Map.Entry<Tile, Integer> entry : this.tally.entrySet()) {
            if (!predicate.test(entry.getKey())) continue;
            val += entry.getValue().intValue();
        }
        return val;
    }

    public final List<T> getBlanks() {
        ArrayList blanks = Lists.newArrayList();
        this.set.entrySet().stream().filter(entry -> ((Tile)entry.getValue()).isBlank()).map(Map.Entry::getKey).forEach(blanks::add);
        return blanks;
    }

    public final void clearOptionCache() {
        this.optionCache.clear();
    }

    public final List<T> getMatchingTiles(BiPredicate<T, Tile> predicate) {
        return this.set.entrySet().stream().filter(e -> predicate.test(e.getKey(), (Tile)e.getValue())).map(Map.Entry::getKey).toList();
    }
}

