/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grid;

import com.google.common.collect.Lists;
import com.lying.grid.AbstractTileGrid;
import com.lying.grid.GraphTileGrid;
import com.lying.init.CDLoggers;
import com.lying.init.CDTiles;
import com.lying.utility.DebugLogger;
import com.lying.worldgen.Tile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.Nullable;

public class BlueprintTileGrid
extends AbstractTileGrid<BlockPos> {
    public static final DebugLogger LOGGER = CDLoggers.WFC;
    public static final Tile BLANK = CDTiles.BLANK.get();
    public static final RandomSource rand = RandomSource.create();
    private final List<TileInstance> finalised = Lists.newArrayList();

    public static BlueprintTileGrid ofSize(BlockPos size) {
        BlueprintTileGrid map = new BlueprintTileGrid();
        int sizeX = Math.abs(size.getX());
        sizeX = sizeX == 0 ? 1 : sizeX;
        int sizeY = Math.abs(size.getY());
        sizeY = sizeY == 0 ? 1 : sizeY;
        int sizeZ = Math.abs(size.getZ());
        sizeZ = sizeZ == 0 ? 1 : sizeZ;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int y = 0; y < sizeY; ++y) {
                    map.addToVolume(new BlockPos(x, y, z));
                }
            }
        }
        return map;
    }

    public static BlueprintTileGrid fromGraphGrid(GraphTileGrid graph, int height) {
        BlueprintTileGrid map = new BlueprintTileGrid();
        graph.contents().forEach(tile -> {
            BlockPos pos = new BlockPos(tile.x, 0, tile.y);
            for (int i = 0; i < height; ++i) {
                map.addToVolume(pos.above(i));
            }
        });
        return map;
    }

    public BlueprintTileGrid addToVolume(BlockPos from, BlockPos to) {
        BlockPos.MutableBlockPos.betweenClosed((BlockPos)from, (BlockPos)to).forEach(p -> this.addToVolume(p.immutable()));
        return this;
    }

    @Override
    public boolean containsAdjacent(BlockPos pos) {
        return this.set.keySet().stream().anyMatch(p2 -> p2.distManhattan((Vec3i)pos) == 1);
    }

    @Override
    public void grow(Direction direction, int size) {
        this.getBoundaries(List.of(direction)).forEach(p -> {
            for (int i = 0; i < size; ++i) {
                this.addToVolume(p.relative(direction));
            }
        });
    }

    public BlockPos size() {
        int x = Integer.MIN_VALUE;
        int y = Integer.MIN_VALUE;
        int z = Integer.MIN_VALUE;
        for (BlockPos pos : this.set.keySet()) {
            if (pos.getX() > x) {
                x = pos.getX();
            }
            if (pos.getY() > y) {
                y = pos.getY();
            }
            if (pos.getZ() <= z) continue;
            z = pos.getZ();
        }
        return new BlockPos(x, y, z).offset(1, 1, 1);
    }

    public boolean isBoundary(BlockPos pos, Direction side) {
        return !this.contains(pos.relative(side));
    }

    @Override
    public List<BlockPos> getBoundaries(List<Direction> faces) {
        return this.set.keySet().stream().filter(p -> faces.stream().anyMatch(f -> this.isBoundary((BlockPos)p, (Direction)f))).toList();
    }

    public void applyToAllValid(Tile tile) {
        Set points = this.set.keySet();
        points.stream().filter(p -> this.get(p).get().isBlank() && tile.canExistAt((BlockPos)p, this)).forEach(p -> this.put((BlockPos)p, tile));
    }

    public List<Tile> getOptionsFor(BlockPos pos, List<Tile> useable) {
        ArrayList options = Lists.newArrayList();
        options.addAll((Collection)this.optionCache.getOrDefault(pos, useable.stream().filter(t -> t.canExistAt(pos, this)).toList()));
        if (!this.optionCache.containsKey(pos)) {
            this.optionCache.put(pos, options);
        }
        return options;
    }

    @Override
    public void put(BlockPos pos, @Nullable Tile tile) {
        super.put(pos, tile);
        this.finalised.clear();
    }

    public void finalise() {
        LOGGER.info("Finalising tile set...");
        this.finalised.clear();
        this.set.entrySet().forEach(entry -> {
            Tile tile = (Tile)entry.getValue();
            if (tile == null || tile.isFlag()) {
                return;
            }
            BlockPos pos = (BlockPos)entry.getKey();
            Rotation rotation = tile.assignRotation(pos, this::get, rand);
            this.finalised.add(new TileInstance(pos, tile, rotation));
        });
        if (!this.finalised.isEmpty()) {
            LOGGER.info("Tile set finalised");
        } else {
            LOGGER.warn("Error while finalising tile set");
        }
    }

    public void finalise(TileInstance instance) {
        this.finalised.removeIf(i -> i.pos().distManhattan((Vec3i)instance.pos()) == 0);
        this.finalised.add(instance);
    }

    public List<TileInstance> getTiles() {
        return this.finalised;
    }

    public boolean generate(BlockPos origin, ServerLevel world) {
        if (this.finalised.isEmpty()) {
            LOGGER.warn("Attempted to generate empty or non-finalised tile set");
            return false;
        }
        this.finalised.forEach(entry -> entry.generate(origin.offset((Vec3i)entry.pos().multiply(2)), world));
        LOGGER.info("Tile set generated successfully");
        return true;
    }

    public record TileInstance(BlockPos pos, Tile tile, Rotation rotation) {
        public void generate(BlockPos position, ServerLevel world) {
            this.tile.generate(this, position, world);
        }
    }
}

