/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grid;

import com.lying.utility.AbstractBox2f;
import com.lying.utility.Box2f;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector2i;

public class GridTile {
    public static final int GRID_SIZE = 2;
    public static final GridTile ZERO = new GridTile(0, 0);
    public static final AbstractBox2f BOUNDS = new Box2f(0.0f, 2.0f, 0.0f, 2.0f);
    public static final AABB BOX = new AABB(0.0, 0.0, 0.0, 2.0, 2.0, 2.0);
    public final int x;
    public final int y;

    public GridTile(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public String toString() {
        return "GridTile[" + this.x + ", " + this.y + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof GridTile && this.manhattanDistance((GridTile)obj) == 0;
    }

    public GridTile copy() {
        return new GridTile(this.x, this.y);
    }

    public static Comparator<GridTile> distSort(GridTile target) {
        return (a, b) -> {
            double bD;
            double aD = a.distance(target);
            return aD < (bD = b.distance(target)) ? -1 : (aD > bD ? 1 : 0);
        };
    }

    public static GridTile median(GridTile ... tiles) {
        float x = 0.0f;
        float y = 0.0f;
        for (GridTile tile : tiles) {
            x += (float)tile.x;
            y += (float)tile.y;
        }
        return GridTile.fromVec(new Vec2(x /= (float)tiles.length, y /= (float)tiles.length));
    }

    public static GridTile worldVecToGrid(Vec2 vec) {
        return GridTile.fromVec(vec.scale(0.0f));
    }

    public static GridTile fromVec(Vec2 vec) {
        return new GridTile((int)(vec.x - vec.x % 2.0f), (int)(vec.y - vec.y % 2.0f));
    }

    public Vec2 toVec2f() {
        return new Vec2((float)this.x, (float)this.y).add(0.5f);
    }

    public Vec2 gridToWorldVec() {
        return this.mul(2).toVec2f();
    }

    public Vector2i toVec2i() {
        return new Vector2i(this.x, this.y);
    }

    public double distance(GridTile tile) {
        return this.distance(tile.x, tile.y);
    }

    public double distance(int xIn, int yIn) {
        double x = this.x - xIn;
        double y = this.y - yIn;
        return Math.sqrt((double)(x * x + y * y));
    }

    public int manhattanDistance(GridTile tile) {
        return Math.abs((int)(this.x - tile.x)) + Math.abs((int)(this.y - tile.y));
    }

    public boolean isAdjacentTo(GridTile tile) {
        return this.manhattanDistance(tile) <= 1;
    }

    public Box2f bounds() {
        return new Box2f(this.x, this.x + 1, this.y, this.y + 1);
    }

    public GridTile offset(@Nullable Direction dir) {
        return this.offset(dir, 1);
    }

    public GridTile offset(@Nullable Direction dir, int distance) {
        if (dir == null || distance == 0) {
            return this.copy();
        }
        return new GridTile(this.x + dir.getStepX() * distance, this.y + dir.getStepZ() * distance);
    }

    public GridTile add(Vector2i vec) {
        return this.add(vec.x, vec.y);
    }

    public GridTile add(int xIn, int yIn) {
        return new GridTile(this.x + xIn, this.y + yIn);
    }

    public GridTile add(GridTile tile) {
        return this.add(tile.x, tile.y);
    }

    public GridTile sub(Vector2i vec) {
        return this.sub(vec.x, vec.y);
    }

    public GridTile sub(int xIn, int yIn) {
        return new GridTile(this.x - xIn, this.y - yIn);
    }

    public BlockPos toPos(int yIn) {
        return new BlockPos(this.x, yIn, this.y);
    }

    public GridTile mul(int scalar) {
        return new GridTile(this.x * scalar, this.y * scalar);
    }
}

