/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.google.common.collect.Lists;
import com.lying.CyclicDungeons;
import com.lying.block.BladeBlock;
import com.lying.block.CollisionSensorBlock;
import com.lying.block.HatchActorBlock;
import com.lying.block.PitBlock;
import com.lying.block.ProximitySensorBlock;
import com.lying.block.RedstoneActorBlock;
import com.lying.block.RedstoneSensorBlock;
import com.lying.block.SightSensorBlock;
import com.lying.block.SoundSensorBlock;
import com.lying.block.SwingingBladeBlock;
import com.lying.block.TrapLogicBlock;
import com.lying.reference.Reference;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CDBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"cydun", (ResourceKey)Registries.BLOCK);
    public static final List<RegistrySupplier<Block>> ALL_BLOCKS = Lists.newArrayList();
    public static final List<RegistrySupplier<Block>> SOLID_CUBES = Lists.newArrayList();
    public static final RegistrySupplier<Block> TRAP_LOGIC = CDBlocks.register("trap_logic", s -> new TrapLogicBlock(s.lightLevel(l -> 3).emissiveRendering(CDBlocks::always)));
    public static final RegistrySupplier<Block> TRAP_LOGIC_DECOY = CDBlocks.register("trap_logic_decoy", s -> new Block(s.lightLevel(l -> 3).emissiveRendering(CDBlocks::always)));
    public static final RegistrySupplier<Block> SENSOR_COLLISION = CDBlocks.register("collision_sensor", CollisionSensorBlock::new);
    public static final RegistrySupplier<Block> SENSOR_PROXIMITY = CDBlocks.register("proximity_sensor", ProximitySensorBlock::new);
    public static final RegistrySupplier<Block> SENSOR_REDSTONE = CDBlocks.register("redstone_sensor", RedstoneSensorBlock::new);
    public static final RegistrySupplier<Block> SENSOR_SIGHT = CDBlocks.register("sight_sensor", SightSensorBlock::new);
    public static final RegistrySupplier<Block> SENSOR_SOUND = CDBlocks.register("sound_sensor", SoundSensorBlock::new);
    public static final RegistrySupplier<Block> PIT = CDBlocks.register("pit", PitBlock::new);
    public static final RegistrySupplier<Block> ACTOR_REDSTONE = CDBlocks.register("redstone_actor", RedstoneActorBlock::new);
    public static final RegistrySupplier<Block> COBBLESTONE_HATCH = CDBlocks.register("cobblestone_hatch", HatchActorBlock::new);
    public static final RegistrySupplier<Block> DIRT_HATCH = CDBlocks.register("dirt_hatch", HatchActorBlock::new);
    public static final RegistrySupplier<Block> GRASS_HATCH = CDBlocks.register("grass_hatch", HatchActorBlock::new);
    public static final RegistrySupplier<Block> STONE_HATCH = CDBlocks.register("stone_hatch", HatchActorBlock::new);
    public static final RegistrySupplier<Block> STONE_BRICK_HATCH = CDBlocks.register("stone_brick_hatch", HatchActorBlock::new);
    public static final RegistrySupplier<Block> SWINGING_BLADE = CDBlocks.register("swinging_blade", SwingingBladeBlock::new);
    public static final RegistrySupplier<Block> BLADE = CDBlocks.register("blade", BladeBlock::new);

    private static RegistrySupplier<Block> registerSolidCube(String nameIn, Function<BlockBehaviour.Properties, Block> supplierIn) {
        RegistrySupplier<Block> registry = CDBlocks.register(nameIn, supplierIn);
        SOLID_CUBES.add(registry);
        return registry;
    }

    private static RegistrySupplier<Block> register(String nameIn, Function<BlockBehaviour.Properties, Block> supplierIn) {
        ResourceLocation id = Reference.ModInfo.prefix(nameIn);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id);
        BlockBehaviour.Properties settings = BlockBehaviour.Properties.of().setId(key);
        RegistrySupplier registry = BLOCKS.register(id, () -> (Block)supplierIn.apply(settings));
        ALL_BLOCKS.add((RegistrySupplier<Block>)registry);
        return registry;
    }

    public static Boolean always(BlockState state, BlockGetter world, BlockPos pos, EntityType<?> type) {
        return true;
    }

    public static Boolean always(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public static Boolean never(BlockState state, BlockGetter world, BlockPos pos, EntityType<?> type) {
        return false;
    }

    public static Boolean never(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    private static BlockBehaviour.Properties copyLootTable(BlockBehaviour.Properties settings, Block block, boolean copyTranslationKey) {
        settings.overrideLootTable(block.getLootTable());
        if (copyTranslationKey) {
            settings.overrideDescription(block.getDescriptionId());
        }
        return settings;
    }

    public static void init() {
        BLOCKS.register();
        CyclicDungeons.LOGGER.info("# Initialised {} blocks", (Object)ALL_BLOCKS.size());
    }
}

