/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.google.common.collect.Lists;
import com.lying.CyclicDungeons;
import com.lying.init.CDBlocks;
import com.lying.item.WiringGunItem;
import com.lying.reference.Reference;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class CDItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"cydun", (ResourceKey)Registries.ITEM);
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((String)"cydun", (ResourceKey)Registries.CREATIVE_MODE_TAB);
    private static int itemTally = 0;
    private static int blockTally = 0;
    public static final List<RegistrySupplier<Item>> BASIC_BLOCK_ITEMS = Lists.newArrayList();
    public static final List<RegistrySupplier<Item>> ALL_BLOCKS = Lists.newArrayList();
    public static final RegistrySupplier<CreativeModeTab> CYDUN_TAB = TABS.register("cydun", () -> CreativeTabRegistry.create((Component)Component.translatable((String)"itemGroup.cydun.item_group"), () -> new ItemStack((ItemLike)Items.SPAWNER)));
    public static final RegistrySupplier<Item> WIRING_GUN = CDItems.register("wiring_gun", (Item.Properties s) -> new WiringGunItem(s.stacksTo(1).fireResistant().rarity(Rarity.EPIC)));
    public static final RegistrySupplier<Item> TRAP_LOGIC = CDItems.registerRareBlock("trap_logic", CDBlocks.TRAP_LOGIC, Rarity.EPIC);
    public static final RegistrySupplier<Item> TRAP_LOGIC_DECOY = CDItems.registerBlockNoItem("trap_logic_decoy", CDBlocks.TRAP_LOGIC_DECOY, s -> s.rarity(Rarity.RARE));
    public static final RegistrySupplier<Item> SENSOR_REDSTONE = CDItems.registerRareBlock("redstone_sensor", CDBlocks.SENSOR_REDSTONE, Rarity.RARE);
    public static final RegistrySupplier<Item> SENSOR_COLLISION = CDItems.registerRareBlock("collision_sensor", CDBlocks.SENSOR_COLLISION, Rarity.RARE);
    public static final RegistrySupplier<Item> SENSOR_SOUND = CDItems.registerRareBlock("sound_sensor", CDBlocks.SENSOR_SOUND, Rarity.RARE);
    public static final RegistrySupplier<Item> SENSOR_SIGHT = CDItems.registerRareBlock("sight_sensor", CDBlocks.SENSOR_SIGHT, Rarity.RARE);
    public static final RegistrySupplier<Item> SENSOR_PROXIMITY = CDItems.registerRareBlock("proximity_sensor", CDBlocks.SENSOR_PROXIMITY, Rarity.RARE);
    public static final RegistrySupplier<Item> PIT = CDItems.registerRareBlockNoItem("pit", CDBlocks.PIT, Rarity.RARE);
    public static final RegistrySupplier<Item> ACTOR_REDSTONE = CDItems.registerRareBlock("redstone_actor", CDBlocks.ACTOR_REDSTONE, Rarity.RARE);
    public static final RegistrySupplier<Item> STONE_BRICK_HATCH = CDItems.registerRareBlock("stone_brick_hatch", CDBlocks.STONE_BRICK_HATCH, Rarity.RARE);
    public static final RegistrySupplier<Item> STONE_HATCH = CDItems.registerRareBlock("stone_hatch", CDBlocks.STONE_HATCH, Rarity.RARE);
    public static final RegistrySupplier<Item> COBBLESTONE_HATCH = CDItems.registerRareBlock("cobblestone_hatch", CDBlocks.COBBLESTONE_HATCH, Rarity.RARE);
    public static final RegistrySupplier<Item> GRASS_HATCH = CDItems.registerRareBlock("grass_hatch", CDBlocks.GRASS_HATCH, Rarity.RARE);
    public static final RegistrySupplier<Item> DIRT_HATCH = CDItems.registerRareBlock("dirt_hatch", CDBlocks.DIRT_HATCH, Rarity.RARE);
    public static final RegistrySupplier<Item> SWINGING_BLADE = CDItems.registerRareBlockNoItem("swinging_blade", CDBlocks.SWINGING_BLADE, Rarity.RARE);

    private static RegistrySupplier<Item> registerBlock(String nameIn, RegistrySupplier<Block> blockIn) {
        return CDItems.registerBlock(nameIn, blockIn, UnaryOperator.identity());
    }

    private static RegistrySupplier<Item> registerRareBlock(String nameIn, RegistrySupplier<Block> blockIn, Rarity rarity) {
        return CDItems.registerBlock(nameIn, blockIn, s -> s.rarity(rarity));
    }

    private static RegistrySupplier<Item> registerRareBlockNoItem(String nameIn, RegistrySupplier<Block> blockIn, Rarity rarity) {
        return CDItems.registerBlockNoItem(nameIn, blockIn, s -> s.rarity(rarity));
    }

    private static RegistrySupplier<Item> registerBlock(String nameIn, RegistrySupplier<Block> blockIn, UnaryOperator<Item.Properties> settingsOp) {
        RegistrySupplier<Item> registry = CDItems.registerBlockNoItem(nameIn, blockIn, settingsOp);
        BASIC_BLOCK_ITEMS.add(registry);
        return registry;
    }

    private static RegistrySupplier<Item> registerBlockNoItem(String nameIn, RegistrySupplier<Block> blockIn) {
        return CDItems.registerBlockNoItem(nameIn, blockIn, UnaryOperator.identity());
    }

    private static RegistrySupplier<Item> registerBlockNoItem(String nameIn, RegistrySupplier<Block> blockIn, UnaryOperator<Item.Properties> settingsOp) {
        ResourceLocation id = Reference.ModInfo.prefix(nameIn);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
        return CDItems.registerBlockItem(nameIn, () -> new BlockItem((Block)blockIn.get(), (Item.Properties)settingsOp.apply(new Item.Properties().useBlockDescriptionPrefix().setId(key).arch$tab(CYDUN_TAB))));
    }

    private static RegistrySupplier<Item> registerBlockItem(String nameIn, Supplier<Item> supplier) {
        RegistrySupplier<Item> registry = CDItems.register(Reference.ModInfo.prefix(nameIn), supplier);
        ALL_BLOCKS.add(registry);
        ++blockTally;
        return registry;
    }

    private static RegistrySupplier<Item> register(String nameIn, Function<Item.Properties, Item> supplierIn) {
        ResourceLocation id = Reference.ModInfo.prefix(nameIn);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
        Item.Properties settings = new Item.Properties().setId(key).arch$tab(CYDUN_TAB);
        return CDItems.register(id, () -> (Item)supplierIn.apply(settings));
    }

    private static RegistrySupplier<Item> register(ResourceLocation id, Supplier<Item> supplierIn) {
        ++itemTally;
        return ITEMS.register(id, supplierIn);
    }

    public static void init() {
        TABS.register();
        ITEMS.register();
        CyclicDungeons.LOGGER.info("# Initialised {} items ({} block items)", (Object)itemTally, (Object)blockTally);
    }
}

