/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.lying.CyclicDungeons;
import com.lying.grammar.GrammarPhrase;
import com.lying.grammar.GrammarRoom;
import com.lying.grammar.GrammarTerm;
import com.lying.init.CDRoomTileSets;
import com.lying.reference.Reference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import org.joml.Vector2i;

public class CDTerms {
    private static final Map<ResourceLocation, Supplier<GrammarTerm>> TERMS = new HashMap<ResourceLocation, Supplier<GrammarTerm>>();
    private static int tally = 0;
    public static final Supplier<GrammarTerm> START = CDTerms.register("start", () -> GrammarTerm.Builder.create(0xFFFFFF, DyeColor.WHITE).size(CDTerms.size(6, 6, 8, 8)).withTileSet(CDRoomTileSets.START_ROOM_TILESET).unplaceable());
    public static final Supplier<GrammarTerm> END = CDTerms.register("end", () -> GrammarTerm.Builder.create(0xFFFFFF, DyeColor.WHITE).size(CDTerms.size(6, 6, 8, 8)).withTileSet(CDRoomTileSets.END_ROOM_TILESET).unplaceable());
    public static final Supplier<GrammarTerm> VOID = CDTerms.register("void", () -> GrammarTerm.Builder.create(0, DyeColor.BLACK).unplaceable());
    public static final Supplier<GrammarTerm> BLANK = CDTerms.register("blank", () -> GrammarTerm.Builder.create(526344, DyeColor.LIGHT_GRAY).unplaceable().replaceable());
    public static final Supplier<GrammarTerm> ADD = CDTerms.register("add_room", () -> GrammarTerm.Builder.create(0xD2D2D2, DyeColor.WHITE).replaceable().sizeCap(6).weight(3).onApply((t, r, g) -> GrammarTerm.injectRoom(r, g)));
    public static final Supplier<GrammarTerm> ADD_BRANCH = CDTerms.register("add_branch", () -> GrammarTerm.Builder.create(0xB9B9B9, DyeColor.WHITE).replaceable().injectsBranches().sizeCap(6).weight(4).onApply((t, r, g) -> GrammarTerm.injectBranch(r, g)));
    public static final Supplier<GrammarTerm> EMPTY = CDTerms.register("empty", () -> GrammarTerm.Builder.create(0xA6A6A6, DyeColor.GRAY).size(CDTerms.size(7, 7, 10, 10)).withTileSet(CDRoomTileSets.EMPTY_ROOM_TILESET).nonconsecutive().allowDeadEnds(false).neverAfter(START).neverBefore(END));
    public static final Supplier<GrammarTerm> BATTLE = CDTerms.register("battle", () -> GrammarTerm.Builder.create(13108999, DyeColor.ORANGE).size(CDTerms.size(8, 8, 14, 14)).withTileSet(CDRoomTileSets.BATTLE_ROOM_TILESET).nonconsecutive().weight(3));
    public static final Supplier<GrammarTerm> TRAP = CDTerms.register("trap", () -> GrammarTerm.Builder.create(11416030, DyeColor.MAGENTA).size(CDTerms.size(6, 6, 8, 8)).withTileSet(CDRoomTileSets.TRAP_ROOM_TILESET).nonconsecutive().weight(2));
    public static final Supplier<GrammarTerm> BIG_PUZZLE = CDTerms.register("big_puzzle", () -> GrammarTerm.Builder.create(3225310, DyeColor.BLUE).size(CDTerms.size(10, 10, 16, 16)).withTileSet(CDRoomTileSets.PUZZLE_ROOM_TILESET).nonconsecutive().popCap(2).onApply(CDTerms::injectTreasure));
    public static final Supplier<GrammarTerm> SML_PUZZLE = CDTerms.register("small_puzzle", () -> GrammarTerm.Builder.create(2582730, DyeColor.LIGHT_BLUE).size(CDTerms.size(5, 5, 8, 8)).withTileSet(CDRoomTileSets.PUZZLE_ROOM_TILESET).nonconsecutive().popCap(4));
    public static final Supplier<GrammarTerm> BOSS = CDTerms.register("boss", () -> GrammarTerm.Builder.create(0x7D1D1D, DyeColor.RED).size(CDTerms.size(16, 16)).withTileSet(CDRoomTileSets.BOSS_ROOM_TILESET).popCap(1).weight(10).neverAfter(START).onlyBefore(END).onApply(CDTerms::injectTreasure));
    public static final Supplier<GrammarTerm> TREASURE = CDTerms.register("treasure", () -> GrammarTerm.Builder.create(16768064, DyeColor.YELLOW).size(CDTerms.size(5, 5)).withTileSet(CDRoomTileSets.TREASURE_ROOM_TILESET).popCap(3).weight(2).onlyAfter(BATTLE, SML_PUZZLE, EMPTY));

    private static void injectTreasure(GrammarTerm t, GrammarRoom r, GrammarPhrase g) {
        GrammarTerm.injectRoom(r, g).applyTerm(TREASURE.get(), g);
    }

    private static Function<RandomSource, Vector2i> size(int x, int y) {
        return r -> new Vector2i(x, y);
    }

    private static Function<RandomSource, Vector2i> size(int minX, int minY, int maxX, int maxY) {
        Function<RandomSource, Integer> x = minX == maxX ? r -> minX : r -> minX + r.nextInt(maxX - minX);
        Function<RandomSource, Integer> y = minY == maxY ? r -> minY : r -> minY + r.nextInt(maxY - minY);
        return r -> new Vector2i(((Integer)x.apply((RandomSource)r)).intValue(), ((Integer)y.apply((RandomSource)r)).intValue());
    }

    private static Supplier<GrammarTerm> register(String name, Supplier<GrammarTerm.Builder> funcIn) {
        ResourceLocation id = Reference.ModInfo.prefix(name);
        GrammarTerm term = funcIn.get().build(id);
        if (term.isPlaceable()) {
            ++tally;
        }
        Supplier<GrammarTerm> sup = () -> term;
        TERMS.put(id, sup);
        return sup;
    }

    public static Optional<GrammarTerm> get(String name) {
        return CDTerms.get(name.contains(":") ? ResourceLocation.parse((String)name) : Reference.ModInfo.prefix(name));
    }

    public static Optional<GrammarTerm> get(ResourceLocation id) {
        return TERMS.containsKey(id) ? Optional.of(TERMS.get(id).get()) : Optional.empty();
    }

    public static List<GrammarTerm> placeables() {
        return TERMS.values().stream().map(Supplier::get).filter(GrammarTerm::isPlaceable).toList();
    }

    public static void init() {
        CyclicDungeons.LOGGER.info("# Initialised {} grammar terms ({} placeable)", (Object)TERMS.size(), (Object)tally);
    }
}

