/*
 * Decompiled with CFR 0.152.
 */
package com.lying.item.component;

import com.lying.block.IWireableBlock;
import com.lying.reference.Reference;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record WiringComponent(Optional<BlockPos> pos, Optional<IWireableBlock.WireRecipient> type) implements TooltipProvider
{
    public static final Codec<WiringComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.optionalFieldOf("target").forGetter(WiringComponent::pos), (App)IWireableBlock.WireRecipient.CODEC.optionalFieldOf("type").forGetter(WiringComponent::type)).apply((Applicative)instance, WiringComponent::new));
    public static final StreamCodec<ByteBuf, WiringComponent> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), WiringComponent::pos, (StreamCodec)ByteBufCodecs.optional(IWireableBlock.WireRecipient.PACKET_CODEC), WiringComponent::type, WiringComponent::new);

    public boolean isWiring() {
        return this.pos.isPresent();
    }

    public static WiringComponent of(BlockPos pos, IWireableBlock.WireRecipient type) {
        return new WiringComponent(Optional.of(pos), Optional.of(type));
    }

    public static WiringComponent empty() {
        return new WiringComponent(Optional.empty(), Optional.empty());
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag type) {
        this.pos.ifPresent(p -> tooltip.accept((Component)Reference.ModInfo.translate("gui", "wire_gun.target", p.toShortString())));
    }
}

