/*
 * Decompiled with CFR 0.152.
 */
package com.lying.network;

import com.lying.grammar.GrammarPhrase;
import com.lying.network.CDPacketHandler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class ShowDungeonLayoutPacket {
    private static final ResourceLocation PACKET_ID = CDPacketHandler.SHOW_DUNGEON_LAYOUT_ID;
    public static final CustomPacketPayload.Type<Payload> PACKET_TYPE = new CustomPacketPayload.Type(PACKET_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, Payload> PACKET_CODEC = CustomPacketPayload.codec(Payload::write, Payload::read);

    public static void sendTo(ServerPlayer player, GrammarPhrase graph, boolean isGenerated) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new Payload(graph, isGenerated));
    }

    public static class Payload
    implements CustomPacketPayload {
        private final GrammarPhrase graph;
        private final boolean isGenerated;

        protected Payload(@NotNull GrammarPhrase graphIn, boolean isGenerated) {
            this.graph = graphIn;
            this.isGenerated = isGenerated;
        }

        public static Payload read(RegistryFriendlyByteBuf buffer) {
            Tag ele = RegistryFriendlyByteBuf.readNbt((ByteBuf)buffer, (NbtAccounter)NbtAccounter.create((long)0x200000L));
            GrammarPhrase graph = GrammarPhrase.fromNbt(ele);
            return new Payload(graph, buffer.readBoolean());
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeNbt(this.graph.toNbt());
            buffer.writeBoolean(this.isGenerated);
        }

        public GrammarPhrase graph() {
            return this.graph;
        }

        public Component title() {
            return this.isGenerated ? Component.literal((String)"Generated dungeon") : Component.literal((String)"Parsed dungeon");
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_TYPE;
        }
    }
}

