/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import com.lying.grid.GridTile;
import com.lying.utility.AbstractBox2f;
import com.lying.utility.Box2f;
import com.lying.utility.Line2f;
import java.util.Iterator;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class LineSegment2f
extends Line2f {
    protected final Vec2 left;
    protected final Vec2 right;
    protected final float minX;
    protected final float maxX;
    protected final float minY;
    protected final float maxY;

    public LineSegment2f(GridTile tileA, GridTile tileB) {
        this(tileA.toVec2f(), tileB.toVec2f());
    }

    public LineSegment2f(Vector2i posA, Vector2i posB) {
        this(new Vec2((float)posA.x, (float)posA.y), new Vec2((float)posB.x, (float)posB.y));
    }

    public LineSegment2f(Vec2 leftIn, Vec2 rightIn) {
        super(leftIn, rightIn);
        this.left = leftIn;
        this.right = rightIn;
        this.minX = Math.min(leftIn.x, rightIn.x);
        this.maxX = Math.max(leftIn.x, rightIn.x);
        this.minY = Math.min(leftIn.y, rightIn.y);
        this.maxY = Math.max(leftIn.y, rightIn.y);
    }

    @Override
    public String toString() {
        float aX = (float)((int)(this.left.x * 100.0f)) / 100.0f;
        float aY = (float)((int)(this.left.y * 100.0f)) / 100.0f;
        float bX = (float)((int)(this.right.x * 100.0f)) / 100.0f;
        float bY = (float)((int)(this.right.y * 100.0f)) / 100.0f;
        return "LineSegment[" + aX + ", " + aY + " to " + bX + ", " + bY + "]";
    }

    public boolean equals(LineSegment2f line) {
        return super.equals(line) && this.minX == line.minX && this.maxX == line.maxX && this.minY == line.minY && this.maxY == line.maxY;
    }

    public boolean simpleEquals(LineSegment2f line) {
        return this.left.equals(line.left) && this.right.equals(line.right) || this.left.equals(line.right) && this.right.equals(this.left);
    }

    @Override
    public boolean contains(@Nullable Vec2 vec) {
        return vec != null && super.contains(vec) && this.inRange(vec);
    }

    @Override
    public Vec2 direction() {
        return this.right.add(this.left.negated());
    }

    public Vec2 midPoint() {
        return this.left.add(this.direction().scale(0.5f));
    }

    public LineSegment2f localTo(Vec2 point) {
        return new LineSegment2f(this.getLeft().add(point.negated()), this.getRight().add(point.negated()));
    }

    public boolean inRange(Vec2 point) {
        float x = point.x;
        float y = point.y;
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY;
    }

    public Vec2 getLeft() {
        return this.left;
    }

    public Vec2 getRight() {
        return this.right;
    }

    public Vec2[] toPoints() {
        return new Vec2[]{this.left, this.right};
    }

    public boolean linksTo(LineSegment2f line) {
        Vec2[] otherPoints = line.toPoints();
        for (Vec2 point : this.toPoints()) {
            for (Vec2 otherPoint : otherPoints) {
                if (point.distanceToSqr(otherPoint) != 0.0f) continue;
                return true;
            }
        }
        return false;
    }

    public LineSegment2f offset(Vec2 offset) {
        return new LineSegment2f(this.left.add(offset), this.right.add(offset));
    }

    public LineSegment2f scale(float scalar) {
        return new LineSegment2f(this.left.scale(scalar), this.right.scale(scalar));
    }

    public float length() {
        Vec2 dir = this.direction();
        float a = Math.abs(dir.x);
        float b = Math.abs(dir.y);
        return (float)Math.sqrt(a * a + b * b);
    }

    public float manhattanLength() {
        Vec2 dir = this.direction();
        return Math.abs(dir.x) + Math.abs(dir.y);
    }

    public boolean isStraightLine() {
        return this.isHorizontal || this.isVertical;
    }

    public AbstractBox2f bounds() {
        return new Box2f(this.minX, this.maxX, this.minY, this.maxY);
    }

    public boolean intersectsAtAll(LineSegment2f other) {
        return this.contains(other.left) || this.contains(other.right) || LineSegment2f.doSegmentsIntersect(this, other);
    }

    public boolean isSame(LineSegment2f line2) {
        return super.isSame(line2) && this.inRange(line2.left) && this.inRange(line2.right);
    }

    @Nullable
    public LineSegment2f clip(AbstractBox2f box) {
        if (!box.intersects(this)) {
            return this;
        }
        boolean leftInside = box.contains(this.left);
        boolean rightInside = box.contains(this.right);
        if (leftInside && rightInside) {
            return null;
        }
        if (leftInside || rightInside) {
            LineSegment2f edge;
            Vec2 intercept = null;
            Iterator<LineSegment2f> iterator = box.asEdges().iterator();
            while (iterator.hasNext() && (intercept = LineSegment2f.segmentIntercept(edge = iterator.next(), this)) == null) {
            }
            if (intercept != null) {
                LineSegment2f clipped = new LineSegment2f(leftInside ? intercept : this.left, rightInside ? intercept : this.right);
                return clipped.length() > 0.0f ? clipped : null;
            }
        }
        return this;
    }

    @Override
    @Nullable
    public Vec2 intercept(Line2f line2) {
        return this.intercept(line2, false);
    }

    @Nullable
    public Vec2 intercept(Line2f other, boolean ignoreRange) {
        Vec2 intercept = super.intercept(other);
        return ignoreRange || this.contains(intercept) ? intercept : null;
    }

    @Nullable
    public static Vec2 segmentIntercept(LineSegment2f a, LineSegment2f b) {
        Vec2 interceptA = a.intercept(b, false);
        Vec2 interceptB = b.intercept(a, false);
        if (interceptA == null || interceptB == null) {
            return null;
        }
        return interceptA.add(interceptB).scale(0.5f);
    }

    public static boolean doSegmentsIntersect(LineSegment2f a, LineSegment2f b) {
        return LineSegment2f.segmentIntercept(a, b) != null;
    }

    public LineSegment2f turnClockwise() {
        Vec2 a = new Vec2(-this.left.y, this.left.x);
        Vec2 b = new Vec2(-this.right.y, this.right.x);
        return new LineSegment2f(a, b);
    }

    public LineSegment2f turnCClockwise() {
        Vec2 a = new Vec2(this.left.y, -this.left.x);
        Vec2 b = new Vec2(this.right.y, -this.right.x);
        return new LineSegment2f(a, b);
    }
}

