/*
 * Decompiled with CFR 0.152.
 */
package com.lying.worldgen;

import com.lying.grid.BlueprintTileGrid;
import com.lying.init.CDLoggers;
import com.lying.init.CDTileTags;
import com.lying.init.CDTiles;
import com.lying.utility.DebugLogger;
import com.lying.worldgen.TilePredicate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public abstract class Tile {
    public static final DebugLogger LOGGER = CDLoggers.WORLDGEN;
    public static final int TILE_SIZE = 2;
    public static final Vec2 TILE = new Vec2(2.0f, 2.0f);
    private final ResourceLocation registryName;
    private final TilePredicate predicate;
    private final GenStyle type;
    private final RotationSupplier rotator;

    public Tile(ResourceLocation id, GenStyle style, TilePredicate predicateIn, RotationSupplier rotatorIn) {
        this.registryName = id;
        this.type = style;
        this.predicate = predicateIn;
        this.rotator = rotatorIn;
    }

    public final boolean equals(Object obj) {
        return obj instanceof Tile && this.is((Tile)obj);
    }

    public final boolean is(Tile tile) {
        return tile.registryName().equals((Object)this.registryName);
    }

    public final ResourceLocation registryName() {
        return this.registryName;
    }

    public final boolean isIn(CDTileTags.TileTag tag) {
        return tag.contains(this.registryName);
    }

    public final boolean isBlank() {
        return this.registryName.equals((Object)CDTiles.BLANK.get().registryName());
    }

    public final boolean isFlag() {
        return this.type == GenStyle.FLAG;
    }

    public final boolean canExistAt(BlockPos pos, BlueprintTileGrid set) {
        return this.predicate.test(this, pos, set);
    }

    @NotNull
    public final Rotation assignRotation(BlockPos pos, Function<BlockPos, Optional<Tile>> getter, RandomSource rand) {
        return this.rotator.assignRotation(pos, getter, rand);
    }

    public abstract void generate(BlueprintTileGrid.TileInstance var1, BlockPos var2, ServerLevel var3);

    public static void tryPlace(BlockState state, BlockPos pos, ServerLevel world) {
        if (!world.getBlockState(pos).is(BlockTags.WITHER_IMMUNE)) {
            world.setBlockAndUpdate(pos, state);
        }
    }

    public static enum GenStyle {
        FLAG,
        BLOCK,
        STRUCTURE;

    }

    @FunctionalInterface
    public static interface RotationSupplier {
        public static final Map<Direction, Rotation> faceToRotationMap = Map.of(Direction.NORTH, Rotation.NONE, Direction.EAST, Rotation.CLOCKWISE_90, Direction.SOUTH, Rotation.CLOCKWISE_180, Direction.WEST, Rotation.COUNTERCLOCKWISE_90);

        @NotNull
        public Rotation assignRotation(BlockPos var1, Function<BlockPos, Optional<Tile>> var2, RandomSource var3);

        public static RotationSupplier none() {
            return (p, g, r) -> Rotation.NONE;
        }

        public static RotationSupplier random() {
            return (p, g, r) -> Rotation.values()[r.nextInt(Rotation.values().length)];
        }

        public static RotationSupplier toFaceAdjacent(Predicate<Tile> predicate) {
            return RotationSupplier.toFaceAdjacent(predicate, RotationSupplier.none());
        }

        public static RotationSupplier againstBoundary(RotationSupplier fallback) {
            return (pos, getter, rand) -> {
                for (Map.Entry<Direction, Rotation> entry : faceToRotationMap.entrySet()) {
                    Optional neighbour = (Optional)getter.apply(pos.relative(entry.getKey()));
                    if (!neighbour.isEmpty()) continue;
                    return entry.getValue();
                }
                return fallback.assignRotation(pos, getter, rand);
            };
        }

        public static RotationSupplier toFaceAdjacent(Predicate<Tile> predicate, RotationSupplier fallback) {
            Map<Direction, Rotation> faceToRotationMap = Map.of(Direction.NORTH, Rotation.NONE, Direction.EAST, Rotation.CLOCKWISE_90, Direction.SOUTH, Rotation.CLOCKWISE_180, Direction.WEST, Rotation.COUNTERCLOCKWISE_90);
            return (pos, getter, rand) -> {
                for (Map.Entry entry : faceToRotationMap.entrySet()) {
                    Optional neighbour = (Optional)getter.apply(pos.relative((Direction)entry.getKey()));
                    if (!neighbour.isPresent() || !predicate.test((Tile)neighbour.get())) continue;
                    return (Rotation)entry.getValue();
                }
                return fallback.assignRotation(pos, getter, rand);
            };
        }
    }

    public static class Builder {
        private final TilePredicate predicate;
        private GenStyle style = GenStyle.FLAG;
        private BlockState[] blockStates = new BlockState[0];
        private ResourceKey<StructureTemplatePool> structureKey = null;
        private RotationSupplier rotationFunc = (p, g, r) -> Rotation.NONE;

        private Builder(TilePredicate predicateIn) {
            this.predicate = predicateIn;
        }

        public static Builder of(TilePredicate predicate) {
            return new Builder(predicate);
        }

        public Builder asFlag() {
            this.style = GenStyle.FLAG;
            return this;
        }

        public Builder asBlock(BlockState ... states) {
            this.style = GenStyle.BLOCK;
            this.blockStates = states;
            return this;
        }

        public Builder asAir() {
            this.style = GenStyle.BLOCK;
            this.blockStates = new BlockState[]{Blocks.AIR.defaultBlockState()};
            return this;
        }

        public Builder asStructure(ResourceKey<StructureTemplatePool> structureKeyIn) {
            this.style = GenStyle.STRUCTURE;
            this.structureKey = structureKeyIn;
            return this;
        }

        public Builder freeRotation() {
            return this.withRotation(RotationSupplier.random());
        }

        public Builder noRotation() {
            return this.withRotation((p, g, r) -> Rotation.NONE);
        }

        public Builder withRotation(RotationSupplier funcIn) {
            this.rotationFunc = funcIn;
            return this;
        }

        public Function<ResourceLocation, Tile> build() {
            switch (this.style.ordinal()) {
                default: {
                    return id -> new Tile(this, (ResourceLocation)id, this.style, this.predicate, RotationSupplier.none()){

                        @Override
                        public void generate(BlueprintTileGrid.TileInstance inst, BlockPos pos, ServerLevel world) {
                        }
                    };
                }
                case 1: {
                    return id -> new Tile((ResourceLocation)id, this.style, this.predicate, RotationSupplier.none()){

                        @Override
                        public void generate(BlueprintTileGrid.TileInstance inst, BlockPos pos, ServerLevel world) {
                            boolean sc = true;
                            BlockPos.MutableBlockPos.betweenClosed((BlockPos)pos, (BlockPos)pos.offset(1, 1, 1)).forEach(p -> Tile.tryPlace(blockStates[world.random.nextInt(blockStates.length)], p, world));
                        }
                    };
                }
                case 2: 
            }
            return id -> new Tile((ResourceLocation)id, this.style, this.predicate, this.rotationFunc){

                @Override
                public void generate(BlueprintTileGrid.TileInstance inst, BlockPos pos, ServerLevel world) {
                    RegistryAccess manager = world.registryAccess();
                    Registry registry = manager.lookupOrThrow(Registries.TEMPLATE_POOL);
                    PoolAliasLookup alias = PoolAliasLookup.create(List.of(), (BlockPos)pos, (long)world.getSeed());
                    Optional poolOpt = Optional.of(structureKey).flatMap(key -> registry.getOptional(alias.lookup(key)));
                    if (poolOpt.isEmpty()) {
                        LOGGER.warn("Blank structure pool: {}", structureKey.location().toString());
                        return;
                    }
                    RandomSource rand = RandomSource.create((long)(pos.getX() * pos.getX() + pos.getZ() * pos.getZ()));
                    StructureTemplateManager structureManager = world.getStructureManager();
                    Rotation rotation = inst.rotation();
                    BlockPos place = pos;
                    if (rotation != Rotation.NONE) {
                        switch (rotation) {
                            case CLOCKWISE_180: {
                                place = place.offset(1, 0, 1);
                                break;
                            }
                            case CLOCKWISE_90: {
                                place = place.offset(1, 0, 0);
                                break;
                            }
                            case COUNTERCLOCKWISE_90: {
                                place = place.offset(0, 0, 1);
                                break;
                            }
                        }
                    }
                    StructurePoolElement element = ((StructureTemplatePool)poolOpt.get()).getRandomTemplate(rand);
                    PoolElementStructurePiece piece = new PoolElementStructurePiece(structureManager, element, place, element.getGroundLevelDelta(), rotation, element.getBoundingBox(structureManager, place, rotation), LiquidSettings.IGNORE_WATERLOGGING);
                    piece.place((WorldGenLevel)world, world.structureManager(), world.getChunkSource().getGenerator(), rand, BoundingBox.fromCorners((Vec3i)pos, (Vec3i)pos.offset(1, 1, 1)), place, false);
                }
            };
        }
    }
}

