/*
 * Decompiled with CFR 0.152.
 */
package alicewritesthings.proton.me.survivalasterisk;

import alicewritesthings.proton.me.survivalasterisk.Config;
import com.mojang.logging.LogUtils;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerRespawnPositionEvent;
import org.slf4j.Logger;

@Mod(value="survivalasterisk")
public class SurvivalAsterisk {
    public static final String MODID = "survivalasterisk";
    public static final Logger LOGGER = LogUtils.getLogger();

    public SurvivalAsterisk(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        NeoForge.EVENT_BUS.addListener(this::randomizeRespawn);
        NeoForge.EVENT_BUS.addListener(this::applyRespawnEffects);
        NeoForge.EVENT_BUS.addListener(this::applyMinimumDamage);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        if (Config.RANDOM_RESPAWNS.getAsBoolean()) {
            LOGGER.info("Respawns are randomized sucker!");
        }
        LOGGER.info("Minimum damage is {} be careful taking more than {} damage", Config.MINIMUM_DAMAGE.get(), (Object)Config.MIN_DAMAGE_THRESHOLD.getAsInt());
    }

    private void randomizeRespawn(PlayerRespawnPositionEvent event) {
        if (event.isFromEndFight() || !((Boolean)Config.RANDOM_RESPAWNS.get()).booleanValue()) {
            return;
        }
        int minRespawnDistance = Config.MIN_RESPAWN_RADIUS.getAsInt();
        int maxRespawnDistance = Config.MAX_RESPAWN_RADIUS.getAsInt();
        Random random = new Random();
        int xDistance = random.nextInt(minRespawnDistance, maxRespawnDistance);
        int zDistance = random.nextInt(minRespawnDistance, maxRespawnDistance);
        TeleportTransition currentTeleport = event.getOriginalTeleportTransition();
        BlockPos deathPos = event.getEntity().getOnPos();
        BlockPos newPos = deathPos.offset(xDistance, 300, zDistance);
        currentTeleport = currentTeleport.withPosition(new Vec3((Vec3i)newPos));
        event.setTeleportTransition(currentTeleport);
    }

    private void applyRespawnEffects(PlayerEvent.PlayerRespawnEvent event) {
        if (!((Boolean)Config.RANDOM_RESPAWNS.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 900));
            serverPlayer.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 900));
        }
    }

    private void applyMinimumDamage(LivingDamageEvent.Pre event) {
        if (!((Boolean)Config.MINIMUM_DAMAGE.get()).booleanValue()) {
            return;
        }
        if (event.getOriginalDamage() >= (float)Config.MIN_DAMAGE_THRESHOLD.getAsInt() && event.getNewDamage() < 1.0f) {
            event.setNewDamage(1.0f);
        }
    }
}

