/*
 * Decompiled with CFR 0.152.
 */
package alicewritesthings.proton.me.survivalasterisk.mixin;

import alicewritesthings.proton.me.survivalasterisk.Config;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodData.class})
public abstract class FoodDataMixin {
    @Shadow
    private float exhaustionLevel;
    @Shadow
    private float saturationLevel;
    @Shadow
    private int foodLevel;
    @Shadow
    private int tickTimer;

    @Shadow
    public abstract void addExhaustion(float var1);

    @Inject(at={@At(value="HEAD")}, method={"tick"}, cancellable=true)
    public void applyNewTick(ServerPlayer Player, CallbackInfo info) {
        if (((Boolean)Config.SATURATION_FIXING.get()).booleanValue()) {
            this.asteriskTick(Player);
            info.cancel();
        }
    }

    public void asteriskTick(ServerPlayer player) {
        boolean flag;
        ServerLevel serverlevel = player.level();
        Difficulty difficulty = serverlevel.getDifficulty();
        if (this.exhaustionLevel > 4.0f) {
            this.exhaustionLevel -= 4.0f;
            if (this.saturationLevel > 0.0f) {
                this.saturationLevel = Math.max(this.saturationLevel - 1.0f, 0.0f);
            } else if (difficulty != Difficulty.PEACEFUL) {
                this.foodLevel = Math.max(this.foodLevel - 1, 0);
            }
        }
        if ((flag = serverlevel.getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) && this.foodLevel >= 10 && player.isHurt()) {
            ++this.tickTimer;
            if (this.tickTimer >= 60) {
                player.heal(1.0f);
                this.tickTimer = 0;
            }
        } else if (flag && this.foodLevel >= 1 && player.isHurt()) {
            ++this.tickTimer;
            if (this.tickTimer >= 100) {
                player.heal(1.0f);
                this.tickTimer = 0;
            }
        } else if (this.foodLevel <= 0) {
            ++this.tickTimer;
            if (this.tickTimer >= 80) {
                if (player.getHealth() > 10.0f || difficulty == Difficulty.HARD || player.getHealth() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.hurtServer(serverlevel, player.damageSources().starve(), 1.0f);
                }
                this.tickTimer = 0;
            }
        } else {
            this.tickTimer = 0;
        }
    }
}

