/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft;

import com.arrl.radiocraft.CommonConfig;
import com.arrl.radiocraft.RadiocraftServerConfig;
import com.arrl.radiocraft.common.init.BENetworkTypes;
import com.arrl.radiocraft.common.init.RadiocraftAntennaTypes;
import com.arrl.radiocraft.common.init.RadiocraftBlockEntities;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import com.arrl.radiocraft.common.init.RadiocraftDataComponent;
import com.arrl.radiocraft.common.init.RadiocraftEntityTypes;
import com.arrl.radiocraft.common.init.RadiocraftItems;
import com.arrl.radiocraft.common.init.RadiocraftMenuTypes;
import com.arrl.radiocraft.common.init.RadiocraftSavedData;
import com.arrl.radiocraft.common.init.RadiocraftSoundEvents;
import com.arrl.radiocraft.common.init.RadiocraftTabs;
import com.arrl.radiocraft.common.network.RadiocraftNetworking;
import com.arrl.radiocraft.compat.TopCompat;
import com.arrl.radiocraft.datagen.RadiocraftBlockTagsProvider;
import com.arrl.radiocraft.datagen.RadiocraftBlockstateProvider;
import com.arrl.radiocraft.datagen.RadiocraftLanguageProvider;
import com.arrl.radiocraft.datagen.RadiocraftRecipesProvider;
import com.mojang.logging.LogUtils;
import java.util.Random;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="radiocraft")
public class Radiocraft {
    public static final String MOD_ID = "radiocraft";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Random RANDOM = new Random();
    public static final boolean IS_DEVELOPMENT_ENV = System.getenv("RADIOCRAFT_DEV_ENV") != null;
    public static final String NETWORK_VERSION = "1";

    public Radiocraft(IEventBus modEventBus) {
        Radiocraft.registerRegistries(modEventBus);
        TopCompatRegistry tcr = new TopCompatRegistry();
        modEventBus.register((Object)tcr);
        NeoForge.EVENT_BUS.register(RadiocraftSavedData.class);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC, "radiocraft-common.toml");
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)RadiocraftServerConfig.SPEC, "radiocraft-server.toml");
    }

    private static void registerRegistries(IEventBus modEventBus) {
        RadiocraftAntennaTypes.register();
        BENetworkTypes.register();
        RadiocraftBlocks.BLOCKS.register(modEventBus);
        RadiocraftItems.ITEMS.register(modEventBus);
        RadiocraftBlockEntities.BLOCK_ENTITY_TYPES.register(modEventBus);
        RadiocraftEntityTypes.ENTITIES.register(modEventBus);
        RadiocraftMenuTypes.MENU_TYPES.register(modEventBus);
        RadiocraftSoundEvents.SOUND_EVENTS.register(modEventBus);
        RadiocraftTabs.CREATIVE_TABS.register(modEventBus);
        RadiocraftDataComponent.DATA_COMPONENTS.register(modEventBus);
        modEventBus.addListener(Radiocraft::gatherData);
        modEventBus.addListener(Radiocraft::registerPackets);
    }

    @SubscribeEvent
    public static void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(NETWORK_VERSION);
        RadiocraftNetworking.register(registrar);
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        gen.addProvider(event.includeServer(), (DataProvider)new RadiocraftBlockTagsProvider(gen.getPackOutput(), event.getLookupProvider(), existingFileHelper));
        gen.addProvider(event.includeClient(), output -> new RadiocraftLanguageProvider(output, "en_us"));
        gen.addProvider(event.includeClient(), output -> new RadiocraftBlockstateProvider(output, existingFileHelper));
        gen.addProvider(true, output -> new RadiocraftRecipesProvider(output, event.getLookupProvider()));
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static String translationKey(String prefix, String suffix) {
        return String.format("%s.%s.%s", prefix, MOD_ID, suffix);
    }

    static class TopCompatRegistry {
        TopCompatRegistry() {
        }

        @SubscribeEvent
        public void commonSetup(FMLCommonSetupEvent event) {
            TopCompat.register();
        }
    }
}

