/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft;

import com.arrl.radiocraft.common.radio.Band;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.neoforge.common.ModConfigSpec;

public class RadiocraftServerConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Integer> HF_FREQUENCY_STEP;
    public static final ModConfigSpec.ConfigValue<Integer> VHF_FREQUENCY_STEP;
    public static final ModConfigSpec.ConfigValue<Integer> ANTENNA_UPDATE_DELAY;
    public static final ModConfigSpec.ConfigValue<Double> HANDHELD_MAX_GAIN;
    public static final ModConfigSpec.ConfigValue<Double> HANDHELD_MAX_MIC_GAIN;
    public static final ModConfigSpec.ConfigValue<Boolean> CALLSIGN_PERMISSIONS_ENABLED;
    public static final Map<String, BandConfig> BAND_CONFIGS;

    static {
        BAND_CONFIGS = new ConcurrentHashMap<String, BandConfig>();
        BUILDER.push("Antenna Options ( * = Restart game to take effect)");
        ANTENNA_UPDATE_DELAY = BUILDER.comment(" Delay in seconds of an antenna to recalculate it's state after being changed #default 5").define("antenna_update_delay", (Object)5);
        BUILDER.pop();
        BUILDER.push("Band Options ( * = Restart game to take effect)");
        HF_FREQUENCY_STEP = BUILDER.comment(" The minimum step size for a HF frequency, in Hz #default 1000").define("hf_frequency_step", (Object)1000);
        VHF_FREQUENCY_STEP = BUILDER.comment(" The minimum step size for a VHF frequency, in Hz #default 100000").define("vhf_frequency_step", (Object)20000);
        BUILDER.pop();
        BUILDER.comment(" While name and frequency are to measures of the same principle, when we refer to a band like say 10m, we mean a range of actual frequencies that aren't exactly 10m in name");
        BUILDER.comment(" Band names like 10m are just for human convenience (so you don't have to say radio capable of 144MHz to 146MHz");
        BAND_CONFIGS.clear();
        for (Band band : Band.getDefaults()) {
            BUILDER.push(band.name().equals("2m") ? band.name() + " band settings, also known as VHF" : band.name() + " band settings");
            BAND_CONFIGS.put(band.name(), new BandConfig(band.name(), (ModConfigSpec.ConfigValue<Integer>)BUILDER.comment(" Line of sight range for this band").define(band.name() + "m_los", (Object)band.losRange()), (ModConfigSpec.ConfigValue<Integer>)BUILDER.comment(" minimum range for the skip effect during the day").define(band.name() + "m_minSkipDay", (Object)band.minSkipDay()), (ModConfigSpec.ConfigValue<Integer>)BUILDER.comment(" maximum range for the skip effect during the day").define(band.name() + "m_maxSkipDay", (Object)band.maxSkipDay()), (ModConfigSpec.ConfigValue<Integer>)BUILDER.comment(" minimum range for the skip effect during the night").define(band.name() + "m_minSkipNight", (Object)band.minSkipNight()), (ModConfigSpec.ConfigValue<Integer>)BUILDER.comment(" maximum range for the skip effect during the night").define(band.name() + "m_maxSkipNight", (Object)band.maxSkipNight()), (ModConfigSpec.ConfigValue<Float>)BUILDER.comment(" The minimum frequency for this band").define(band.name() + "m_minFrequency", (Object)Float.valueOf(band.minFrequency())), (ModConfigSpec.ConfigValue<Float>)BUILDER.comment(" The maximum frequency for this band").define(band.name() + "m_maxFrequency", (Object)Float.valueOf(band.maxFrequency()))));
            BUILDER.pop();
        }
        BUILDER.push("VHF Handheld Options");
        HANDHELD_MAX_GAIN = BUILDER.comment(" Maximum output gain").defineInRange("handheld_max_gain", 5.0, 1.0, 25.0);
        HANDHELD_MAX_MIC_GAIN = BUILDER.comment(" Maximum microphone gain").defineInRange("handheld_max_mic_gain", 5.0, 1.0, 25.0);
        BUILDER.pop();
        BUILDER.push("Permissions");
        CALLSIGN_PERMISSIONS_ENABLED = BUILDER.comment(" Require op for callsign configuration").define("callsign_permissions_enabled", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public record BandConfig(String name, ModConfigSpec.ConfigValue<Integer> losRange, ModConfigSpec.ConfigValue<Integer> minSkipDay, ModConfigSpec.ConfigValue<Integer> maxSkipDay, ModConfigSpec.ConfigValue<Integer> minSkipNight, ModConfigSpec.ConfigValue<Integer> maxSkipNight, ModConfigSpec.ConfigValue<Float> minFrequency, ModConfigSpec.ConfigValue<Float> maxFrequency) {
        public Band getBand() {
            return new Band(this.name, (Integer)this.losRange.get(), (Integer)this.minSkipDay.get(), (Integer)this.maxSkipDay.get(), (Integer)this.minSkipNight.get(), (Integer)this.maxSkipNight.get(), ((Float)this.minFrequency.get()).floatValue(), ((Float)this.maxFrequency.get()).floatValue());
        }
    }
}

