/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.api.antenna;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.antenna.IAntennaType;
import com.arrl.radiocraft.common.radio.antenna.StaticAntenna;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class AntennaTypes {
    private static final Map<ResourceLocation, IAntennaType<?>> REGISTRY = new HashMap();

    public static <C extends IAntennaType<?>> C registerType(C type) {
        ResourceLocation id = type.getId();
        if (REGISTRY.containsKey(id)) {
            Radiocraft.LOGGER.warn("Attempted to register a duplicate Antenna Type of ID {}", (Object)id.toString());
        } else {
            REGISTRY.put(id, type);
        }
        return type;
    }

    public static IAntennaType<?> getType(ResourceLocation id) {
        return REGISTRY.get(id);
    }

    public static StaticAntenna<?> match(Level level, BlockPos pos) {
        for (IAntennaType<?> type : REGISTRY.values()) {
            StaticAntenna<?> antenna = type.match(level, pos);
            if (antenna == null) continue;
            return antenna;
        }
        return null;
    }
}

