/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.api.benetworks;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.benetworks.BENetwork;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BENetworkObject {
    public static final ResourceLocation DEFAULT_TYPE = Radiocraft.id("default");
    protected final Map<Direction, BENetwork> networks = new HashMap<Direction, BENetwork>();
    protected final Level level;
    protected final BlockPos pos;

    public BENetworkObject(Level level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
    }

    public void tick(Level level, BlockPos pos) {
    }

    public BENetwork getNetwork(@NotNull Direction side) {
        return this.networks.get(side);
    }

    public void setNetwork(@NotNull Direction side, BENetwork network) {
        this.networks.put(side, network);
    }

    public void replaceNetwork(BENetwork original, BENetwork newNetwork) {
        for (Direction dir : this.networks.keySet()) {
            if (this.networks.get(dir) != original) continue;
            this.setNetwork(dir, newNetwork);
            return;
        }
    }

    public void clearNetworks() {
        for (BENetwork network : this.networks.values()) {
            network.remove(this, true);
        }
        this.networks.clear();
    }

    public ResourceLocation getType() {
        return DEFAULT_TYPE;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Level getLevel() {
        return this.level;
    }

    public void onNetworkUpdateAdd(BENetwork network, BENetworkObject object) {
    }

    public void onNetworkUpdateRemove(BENetwork network, BENetworkObject object) {
    }

    public void onNetworkAdd(BENetwork network) {
    }

    public void onNetworkRemove(BENetwork network) {
    }

    public void save(CompoundTag nbt) {
        CompoundTag networksTag = new CompoundTag();
        for (Map.Entry<Direction, BENetwork> entry : this.networks.entrySet()) {
            networksTag.putUUID(entry.getKey().getName(), entry.getValue().getUUID());
        }
        nbt.put("networks", (Tag)networksTag);
    }

    public void load(IBENetworks cap, CompoundTag nbt) {
        CompoundTag networksTag = nbt.getCompound("networks");
        for (String key : networksTag.getAllKeys()) {
            BENetwork network = cap.getNetwork(networksTag.getUUID(key));
            network.add(this);
            this.networks.put(Direction.byName((String)key), network);
        }
    }

    public void discard() {
        for (BENetwork network : this.networks.values()) {
            network.remove(this, false);
        }
    }
}

