/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.api.benetworks;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.benetworks.BENetwork;
import com.arrl.radiocraft.api.benetworks.BENetworkObject;
import com.arrl.radiocraft.api.benetworks.PowerNetworkObject;
import com.arrl.radiocraft.common.be_networks.network_objects.BatteryNetworkObject;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;

public class PowerBENetwork
extends BENetwork {
    public static final ResourceLocation TYPE = Radiocraft.id("power");

    public PowerBENetwork(UUID uuid) {
        super(uuid);
    }

    public PowerBENetwork() {
        super(UUID.randomUUID());
    }

    public int pullPower(int amount, boolean simulate) {
        int pulled = 0;
        for (BENetworkObject obj : this.networkObjects) {
            if ((pulled += ((PowerNetworkObject)obj).getStorage().extractEnergy(amount - pulled, simulate)) < amount) continue;
            return pulled;
        }
        return pulled;
    }

    public int pushPower(int amount, boolean direct, boolean forBatteries, boolean simulate) {
        int pushed = 0;
        for (BENetworkObject o : this.networkObjects) {
            PowerNetworkObject obj = (PowerNetworkObject)o;
            if ((!forBatteries || !(obj instanceof BatteryNetworkObject)) && (forBatteries || obj instanceof BatteryNetworkObject) || (direct || !obj.isIndirectConsumer()) && (!direct || !obj.isDirectConsumer()) || (pushed += obj.getStorage().receiveEnergy(amount - pushed, simulate)) < amount) continue;
            return pushed;
        }
        return pushed;
    }

    @Override
    public void add(BENetworkObject networkObject) {
        if (networkObject instanceof PowerNetworkObject) {
            super.add(networkObject);
        } else {
            Radiocraft.LOGGER.warn("Tried to add a non PowerNetworkObject to a PowerBENetwork.");
        }
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }
}

