/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.api.benetworks;

import com.arrl.radiocraft.api.benetworks.BENetworkObject;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import com.arrl.radiocraft.common.capabilities.BasicEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;

public abstract class PowerNetworkObject
extends BENetworkObject {
    protected BasicEnergyStorage energyStorage;

    public PowerNetworkObject(Level level, BlockPos pos, int capacity, int maxReceive, int maxExtract) {
        super(level, pos);
        this.energyStorage = new BasicEnergyStorage(capacity, maxReceive, maxExtract);
    }

    public BasicEnergyStorage getStorage() {
        return this.energyStorage;
    }

    public abstract boolean isIndirectConsumer();

    public abstract boolean isDirectConsumer();

    protected boolean tryConsumeEnergy(int amount, boolean simulate) {
        return this.energyStorage.extractEnergy(amount, simulate) == amount;
    }

    @Override
    public void save(CompoundTag nbt) {
        super.save(nbt);
        if (this.energyStorage != null) {
            this.energyStorage.saveAdditional(nbt);
        }
    }

    @Override
    public void load(IBENetworks cap, CompoundTag nbt) {
        super.load(cap, nbt);
        this.energyStorage = new BasicEnergyStorage(nbt.getInt("capacity"), nbt.getInt("maxReceive"), nbt.getInt("maxExtract"), nbt.getInt("energy"));
    }
}

