/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.entity;

import com.arrl.radiocraft.common.entities.AntennaWire;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class AntennaWireEntityRenderer
extends EntityRenderer<AntennaWire> {
    public AntennaWireEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public boolean shouldRender(@NotNull AntennaWire wire, @NotNull Frustum camera, double camX, double camY, double camZ) {
        Player wireHolder = wire.getWireHolder();
        if (!wire.blockPosition().equals((Object)wire.getEndPos())) {
            return true;
        }
        return wireHolder != null && camera.isVisible(wireHolder.getBoundingBoxForCulling());
    }

    public void render(@NotNull AntennaWire wire, float yaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        super.render((Entity)wire, yaw, partialTick, poseStack, buffer, packedLight);
        Player holder = wire.getWireHolder();
        if (holder != null) {
            this.renderAntennaWire(wire, partialTick, poseStack, buffer, holder);
        } else {
            this.renderAntennaWire(wire, partialTick, poseStack, buffer, wire.getEndPart());
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull AntennaWire entity) {
        return null;
    }

    private static BlockPos blockPosFromVec3(Vec3 vec3) {
        int x = (int)vec3.x;
        int y = (int)vec3.y;
        int z = (int)vec3.z;
        return new BlockPos(x, y, z);
    }

    private <E extends Entity> void renderAntennaWire(E toEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, E fromEntity) {
        int i;
        double lerpBodyAngle = Mth.lerp((float)partialTick, (float)toEntity.yRotO, (float)toEntity.getYRot()) * ((float)Math.PI / 180) + 1.5707964f;
        Vec3 leashOffset = toEntity.getLeashOffset(partialTick);
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.z + Math.sin(lerpBodyAngle) * leashOffset.x;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.z - Math.cos(lerpBodyAngle) * leashOffset.x;
        Vec3 toPos = new Vec3(toEntity.getX() + xAngleOffset, toEntity.getY() + leashOffset.y, toEntity.getZ() + zAngleOffset);
        Vec3 fromPos = fromEntity.getRopeHoldPosition(partialTick);
        float xDiff = (float)(fromPos.x - toPos.x);
        float yDiff = (float)(fromPos.y - toPos.y);
        float zDiff = (float)(fromPos.z - toPos.z);
        float offsetMod = Mth.invSqrt((float)(xDiff * xDiff + zDiff * zDiff)) * 0.025f / 2.0f;
        float xOffset = zDiff * offsetMod;
        float zOffset = xDiff * offsetMod;
        BlockPos toEyePos = new BlockPos((Vec3i)AntennaWireEntityRenderer.blockPosFromVec3(toEntity.getEyePosition(partialTick)));
        BlockPos fromEyePos = new BlockPos((Vec3i)AntennaWireEntityRenderer.blockPosFromVec3(fromEntity.getEyePosition(partialTick)));
        int toBlockLight = toEntity.level().getBrightness(LightLayer.BLOCK, toEyePos);
        int fromBlockLight = fromEntity.level().getBrightness(LightLayer.BLOCK, fromEyePos);
        int toSkyLight = toEntity.level().getBrightness(LightLayer.SKY, toEyePos);
        int fromSkyLight = fromEntity.level().getBrightness(LightLayer.SKY, fromEyePos);
        VertexConsumer consumer = buffer.getBuffer(RenderType.leash());
        Matrix4f posMatrix = poseStack.last().pose();
        int stepCount = fromEntity instanceof Player ? 24 : (int)Math.round(new Vec3((double)xDiff, (double)yDiff, (double)zDiff).length()) * 3;
        poseStack.pushPose();
        poseStack.translate(xAngleOffset, leashOffset.y, zAngleOffset);
        for (i = 0; i <= stepCount; ++i) {
            AntennaWireEntityRenderer.addVertexPair(consumer, posMatrix, xDiff, yDiff, zDiff, toBlockLight, fromBlockLight, toSkyLight, fromSkyLight, 0.025f, 0.025f, xOffset, zOffset, i, false, stepCount);
        }
        for (i = stepCount; i >= 0; --i) {
            AntennaWireEntityRenderer.addVertexPair(consumer, posMatrix, xDiff, yDiff, zDiff, toBlockLight, fromBlockLight, toSkyLight, fromSkyLight, 0.025f, 0.0f, xOffset, zOffset, i, true, stepCount);
        }
        poseStack.popPose();
    }

    private static void addVertexPair(VertexConsumer consumer, Matrix4f matrix, float xDif, float yDif, float zDif, int toBlockLight, int fromBlockLight, int toSkyLight, int fromSkyLight, float width, float yOffset, float xOffset, float zOffset, int distance, boolean isKnot, int stepCount) {
        float f = (float)distance / (float)stepCount;
        int blockLight = (int)Mth.lerp((float)f, (float)toBlockLight, (float)fromBlockLight);
        int skyLight = (int)Mth.lerp((float)f, (float)toSkyLight, (float)fromSkyLight);
        float baseColor = distance % 2 == (isKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.4f * baseColor;
        float green = 0.4f * baseColor;
        float blue = 0.4f * baseColor;
        float x = xDif * f;
        float y = yDif > 0.0f ? yDif * f * f : yDif - yDif * (1.0f - f) * (1.0f - f);
        float z = zDif * f;
        consumer.addVertex(matrix, x - xOffset, y + yOffset, z + zOffset).setColor(red, green, blue, 1.0f).setUv(0.0f, 0.0f).setOverlay(0).setUv2(blockLight, skyLight).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(matrix, x + xOffset, y + width - yOffset, z - zOffset).setColor(red, green, blue, 1.0f).setUv(1.0f, 0.0f).setOverlay(0).setUv2(blockLight, skyLight).setNormal(0.0f, 1.0f, 0.0f);
    }
}

