/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.events;

import com.arrl.radiocraft.api.capabilities.IVHFHandheldCapability;
import com.arrl.radiocraft.client.RadiocraftClientValues;
import com.arrl.radiocraft.common.capabilities.RadiocraftCapabilities;
import com.arrl.radiocraft.common.network.serverbound.SPlayerClickHoldUpdate;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="radiocraft", value={Dist.CLIENT})
public class ClientTick {
    private static boolean wasUseHeld = false;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        boolean isUseHeld = Minecraft.getInstance().options.keyUse.isDown();
        if (isUseHeld != wasUseHeld) {
            SPlayerClickHoldUpdate.updateServer(isUseHeld);
            boolean holdingRadio = Optional.ofNullable(Minecraft.getInstance().player).map(LivingEntity::getMainHandItem).map(i -> (IVHFHandheldCapability)i.getCapability(RadiocraftCapabilities.VHF_HANDHELDS)).isPresent();
            RadiocraftClientValues.SCREEN_VOICE_ENABLED = isUseHeld && !Minecraft.getInstance().options.keyShift.isDown() && holdingRadio;
            RadiocraftClientValues.SCREEN_PTT_PRESSED = RadiocraftClientValues.SCREEN_VOICE_ENABLED;
            if (holdingRadio && !Minecraft.getInstance().options.keyShift.isDown()) {
                if (isUseHeld) {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                } else {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.3f));
                }
            }
        }
        wasUseHeld = isUseHeld;
    }
}

