/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.events;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.common.init.RadiocraftItems;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ItemRenderEvents {
    private static final ResourceLocation DEV_BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"radiocraft", (String)"textures/gui/dev_item_background.png");
    private static final List<Supplier<? extends Item>> DEV_REGULAR_ITEMS = List.of(RadiocraftItems.WATERPROOF_WIRE);
    private static final List<Supplier<BlockItem>> DEV_BLOCK_ITEMS = List.of(RadiocraftItems.SOLAR_PANEL, RadiocraftItems.LARGE_BATTERY, RadiocraftItems.CHARGE_CONTROLLER, RadiocraftItems.SOLAR_WEATHER_STATION, RadiocraftItems.VHF_BASE_STATION, RadiocraftItems.VHF_RECEIVER, RadiocraftItems.VHF_REPEATER, RadiocraftItems.HF_RADIO_10M, RadiocraftItems.HF_RADIO_20M, RadiocraftItems.HF_RADIO_40M, RadiocraftItems.HF_RADIO_80M, RadiocraftItems.HF_RECEIVER, RadiocraftItems.ALL_BAND_RADIO, RadiocraftItems.QRP_RADIO_20M, RadiocraftItems.QRP_RADIO_40M, RadiocraftItems.DUPLEXER, RadiocraftItems.ANTENNA_TUNER, RadiocraftItems.ANTENNA_CONNECTOR, RadiocraftItems.BALUN_ONE_TO_ONE, RadiocraftItems.BALUN_TWO_TO_ONE, RadiocraftItems.COAX_WIRE, RadiocraftItems.DIGITAL_INTERFACE, RadiocraftItems.YAGI_ANTENNA, RadiocraftItems.J_POLE_ANTENNA, RadiocraftItems.SLIM_JIM_ANTENNA, RadiocraftItems.MICROPHONE);
    private static final List<DeferredHolder<Item, ?>> DEV_SPECIAL_ITEMS = List.of(RadiocraftItems.ANTENNA_POLE, RadiocraftItems.SMALL_BATTERY, RadiocraftItems.ANTENNA_WIRE);
    private static Set<Item> devItems = null;

    private static Set<Item> getDevItems() {
        if (devItems == null) {
            devItems = new HashSet<Item>();
            for (Supplier<? extends Item> supplier : DEV_REGULAR_ITEMS) {
                try {
                    Item item2 = supplier.get();
                    if (item2 == null) continue;
                    devItems.add(item2);
                }
                catch (Exception item2) {}
            }
            for (Supplier<? extends Item> supplier : DEV_BLOCK_ITEMS) {
                try {
                    Item item3 = supplier.get();
                    if (item3 == null) continue;
                    devItems.add(item3);
                }
                catch (Exception item3) {}
            }
            for (DeferredHolder deferredHolder : DEV_SPECIAL_ITEMS) {
                try {
                    Item item = (Item)deferredHolder.get();
                    if (item == null) continue;
                    devItems.add(item);
                }
                catch (Exception exception) {}
            }
        }
        return devItems;
    }

    public static boolean isDevItem(ItemStack itemStack) {
        return Radiocraft.IS_DEVELOPMENT_ENV && ItemRenderEvents.getDevItems().contains(itemStack.getItem());
    }

    public static void renderDevBackground(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        guiGraphics.blit(DEV_BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

