/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.screens;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.client.screens.widgets.ToggleButton;
import com.arrl.radiocraft.common.init.RadiocraftItems;
import com.arrl.radiocraft.common.menus.ChargeControllerMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ChargeControllerScreen
extends AbstractContainerScreen<ChargeControllerMenu> {
    private static final ResourceLocation TEXTURE = Radiocraft.id("textures/gui/charge_controller.png");
    private static final ResourceLocation WIDGETS = Radiocraft.id("textures/gui/charge_controller_widgets.png");
    private static final int COIL_WIDTH = 24;
    private static final int COIL_HEIGHT = 35;
    private static final int COIL_U = 176;
    private static final int COIL_V = 57;
    private static final int GAUGE_X = 68;
    private static final int GAUGE_Y = 75;
    private static final int GAUGE_U = 0;
    private static final int GAUGE_V = 0;
    private static final int GAUGE_WIDTH = 53;
    private static final int GAUGE_HEIGHT = 28;
    private static final int LIGHT_SIZE = 19;
    private static final int LIGHT_X = 21;
    private static final int[] LIGHT_Y = new int[]{25, 48, 71};
    private static final int LIGHT_U = 176;
    private static final int[] LIGHT_V = new int[]{0, 19, 38};

    public ChargeControllerScreen(ChargeControllerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 213;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ToggleButton(((ChargeControllerMenu)this.menu).blockEntity.getPoweredOn(), this.leftPos + 138, this.topPos + 19, 27, 82, 0, 0, WIDGETS, 256, 256, button -> {}));
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int edgeSpacingX = (this.width - this.imageWidth) / 2;
        int edgeSpacingY = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(TEXTURE, edgeSpacingX, edgeSpacingY, 0, 0, this.imageWidth, this.imageHeight);
        if (((ChargeControllerMenu)this.menu).blockEntity.getPoweredOn()) {
            ItemStack stack;
            if (((ChargeControllerMenu)this.menu).getPowerTick() == 0) {
                pGuiGraphics.blit(TEXTURE, this.leftPos + 21, this.topPos + LIGHT_Y[0], 176, LIGHT_V[0], 19, 19);
            } else {
                pGuiGraphics.blit(TEXTURE, this.leftPos + 21, this.topPos + LIGHT_Y[2], 176, LIGHT_V[2], 19, 19);
            }
            if (((ChargeControllerMenu)this.menu).getItems().getFirst() != ItemStack.EMPTY) {
                pGuiGraphics.blit(TEXTURE, this.leftPos + 21, this.topPos + LIGHT_Y[1], 176, LIGHT_V[1], 19, 19);
            }
            if ((stack = (ItemStack)((ChargeControllerMenu)this.menu).getItems().getFirst()).getItem() == RadiocraftItems.SMALL_BATTERY.get()) {
                // empty if block
            }
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        super.renderLabels(pGuiGraphics, pMouseX, pMouseY);
        if (this.isHovering(68, 75, 53, 28, pMouseX, pMouseY)) {
            pGuiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)Radiocraft.translationKey("screen", "chargecontroller.power"), (Object[])new Object[]{((ChargeControllerMenu)this.menu).getPowerTick()}), pMouseX - this.leftPos, pMouseY - this.topPos);
        }
        if (this.isHovering(21, LIGHT_Y[0], 19, 19, pMouseX, pMouseY)) {
            pGuiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)Radiocraft.translationKey("screen", "chargecontroller.no_output")), pMouseX - this.leftPos, pMouseY - this.topPos);
        } else if (this.isHovering(21, LIGHT_Y[1], 19, 19, pMouseX, pMouseY)) {
            pGuiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)Radiocraft.translationKey("screen", "chargecontroller.charging")), pMouseX - this.leftPos, pMouseY - this.topPos);
        } else if (this.isHovering(21, LIGHT_Y[2], 19, 19, pMouseX, pMouseY)) {
            pGuiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)Radiocraft.translationKey("screen", "chargecontroller.output")), pMouseX - this.leftPos, pMouseY - this.topPos);
        }
    }

    protected void renderBg(@NotNull GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (mouseX -= (double)this.leftPos) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)this.topPos) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }
}

