/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.screens;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.common.menus.LargeBatteryMenu;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class LargeBatteryScreen
extends AbstractContainerScreen<LargeBatteryMenu> {
    private static final ResourceLocation TEXTURE = Radiocraft.id("textures/gui/large_battery.png");
    private final LargeBatteryMenu menu;

    public LargeBatteryScreen(LargeBatteryMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.menu = menu;
        this.imageWidth = 186;
        this.imageHeight = 122;
    }

    protected void renderBg(@NotNull GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        int edgeSpacingX = (this.width - this.imageWidth) / 2;
        int edgeSpacingY = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(TEXTURE, edgeSpacingX, edgeSpacingY, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        super.renderLabels(pGuiGraphics, pMouseX, pMouseY);
        String powerString = Math.round((float)this.menu.getCurrentPower() / (float)this.menu.getMaxPower() * 100.0f) + "%";
        int xPos = 95 - this.font.width(powerString) / 2;
        Objects.requireNonNull(this.font);
        int yPos = 70 - 9 / 2;
        pGuiGraphics.drawString(this.font, powerString, xPos, yPos, 0xFFFFFF);
    }
}

