/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.screens.radios;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.RadiocraftServerConfig;
import com.arrl.radiocraft.client.screens.radios.HFRadioScreen;
import com.arrl.radiocraft.client.screens.widgets.Dial;
import com.arrl.radiocraft.client.screens.widgets.HoldButton;
import com.arrl.radiocraft.client.screens.widgets.ToggleButton;
import com.arrl.radiocraft.client.screens.widgets.ValueButton;
import com.arrl.radiocraft.common.blockentities.radio.QRPRadio40mBlockEntity;
import com.arrl.radiocraft.common.menus.QRPRadio40mMenu;
import com.arrl.radiocraft.common.radio.Band;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class QRPRadio40mScreen
extends HFRadioScreen<QRPRadio40mMenu> {
    public QRPRadio40mScreen(QRPRadio40mMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title, Radiocraft.id("textures/gui/qrp_radio_40m.png"), Radiocraft.id("textures/gui/qrp_radio_40m_widgets.png"));
        this.imageWidth = 252;
        this.imageHeight = 130;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ToggleButton(((QRPRadio40mMenu)this.menu).isPowered(), this.leftPos + 16, this.topPos + 9, 20, 21, 0, 0, this.widgetsTexture, 256, 256, this::onPressPower));
        this.addRenderableWidget((GuiEventListener)new ValueButton(this.leftPos + 195, this.topPos + 48, 34, 19, 0, 42, this.widgetsTexture, 256, 256, () -> ((QRPRadio40mBlockEntity)((QRPRadio40mMenu)this.menu).blockEntity).getCWEnabled(), this::onPressCW));
        this.addRenderableWidget((GuiEventListener)new ValueButton(this.leftPos + 195, this.topPos + 68, 34, 19, 0, 80, this.widgetsTexture, 256, 256, () -> ((QRPRadio40mBlockEntity)((QRPRadio40mMenu)this.menu).blockEntity).getSSBEnabled(), this::onPressSSB));
        this.addRenderableWidget((GuiEventListener)new HoldButton(this.leftPos + 178, this.topPos + 97, 51, 19, 0, 118, this.widgetsTexture, 256, 256, this::onPressPTT, this::onReleasePTT));
        this.addRenderableWidget((GuiEventListener)new Dial(this.leftPos + 48, this.topPos + 47, 42, 42, 121, 0, this.widgetsTexture, 256, 256, this::onFrequencyDialUp, this::onFrequencyDialDown));
        this.addRenderableWidget((GuiEventListener)new Dial(this.leftPos + 31, this.topPos + 36, 15, 15, 121, 85, this.widgetsTexture, 256, 256, this::doNothing, this::doNothing));
        this.addRenderableWidget((GuiEventListener)new Dial(this.leftPos + 31, this.topPos + 62, 15, 15, 121, 85, this.widgetsTexture, 256, 256, this::doNothing, this::doNothing));
    }

    protected void renderBg(@NotNull GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
    }

    @Override
    protected void renderAdditionalBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        float freq = ((QRPRadio40mMenu)this.menu).getFrequency();
        Band band = ((QRPRadio40mMenu)this.menu).getBand();
        int step = (Integer)RadiocraftServerConfig.HF_FREQUENCY_STEP.get();
        float min = band.minFrequency();
        float max = (band.maxFrequency() - band.minFrequency()) / (float)step * (float)step + min;
        if (!((QRPRadio40mMenu)this.menu).isPowered() || freq >= max || freq <= min) {
            // empty if block
        }
    }
}

