/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.screens.radios;

import com.arrl.radiocraft.client.RadiocraftClientValues;
import com.arrl.radiocraft.client.screens.widgets.Dial;
import com.arrl.radiocraft.client.screens.widgets.HoldButton;
import com.arrl.radiocraft.client.screens.widgets.ToggleButton;
import com.arrl.radiocraft.client.screens.widgets.ValueButton;
import com.arrl.radiocraft.common.blockentities.radio.RadioBlockEntity;
import com.arrl.radiocraft.common.menus.RadioMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public abstract class RadioScreen<T extends RadioMenu<?>>
extends AbstractContainerScreen<T> {
    protected final ResourceLocation texture;
    protected final ResourceLocation widgetsTexture;
    protected final T menu;

    public RadioScreen(T menu, Inventory inventory, Component title, ResourceLocation texture, ResourceLocation widgetsTexture) {
        super(menu, inventory, title);
        this.menu = menu;
        this.texture = texture;
        this.widgetsTexture = widgetsTexture;
    }

    public void onClose() {
        super.onClose();
        RadiocraftClientValues.SCREEN_PTT_PRESSED = false;
        RadiocraftClientValues.SCREEN_VOICE_ENABLED = false;
        RadiocraftClientValues.SCREEN_CW_ENABLED = false;
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderAdditionalTooltips(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    protected void renderAdditionalTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    public void renderBackground(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        int edgeSpacingX = (this.width - this.imageWidth) / 2;
        int edgeSpacingY = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(this.texture, edgeSpacingX, edgeSpacingY, 0, 0, this.imageWidth, this.imageHeight);
        this.renderAdditionalBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    protected void renderAdditionalBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean value = super.mouseReleased(mouseX, mouseY, button);
        for (GuiEventListener listener : this.children()) {
            if (listener.isMouseOver(mouseX, mouseY) || !(listener instanceof Dial)) continue;
            listener.mouseReleased(mouseX, mouseY, button);
        }
        return value;
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (mouseX -= (double)this.leftPos) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)this.topPos) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    protected void doNothing(AbstractWidget button) {
    }

    protected void onPressPTT(HoldButton button) {
        RadiocraftClientValues.SCREEN_PTT_PRESSED = true;
    }

    protected void onReleasePTT(HoldButton button) {
        RadiocraftClientValues.SCREEN_PTT_PRESSED = false;
    }

    protected void onPressPower(ToggleButton button) {
    }

    protected void onPressSSB(ValueButton button) {
        boolean ssbEnabled = ((RadioBlockEntity)((RadioMenu)((Object)this.menu)).blockEntity).getSSBEnabled();
        ((RadioBlockEntity)((RadioMenu)((Object)this.menu)).blockEntity).setSSBEnabled(!ssbEnabled);
    }

    protected void onFrequencyDialUp(Dial dial) {
        if (((RadioMenu)((Object)this.menu)).isPowered()) {
            // empty if block
        }
    }

    protected void onFrequencyDialDown(Dial dial) {
        if (((RadioMenu)((Object)this.menu)).isPowered()) {
            // empty if block
        }
    }

    protected void onFrequencyButtonUp(Button button) {
        if (((RadioMenu)((Object)this.menu)).isPowered()) {
            // empty if block
        }
    }

    protected void onFrequencyButtonDown(Button button) {
        if (((RadioMenu)((Object)this.menu)).isPowered()) {
            // empty if block
        }
    }
}

