/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.screens.radios;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.RadiocraftServerConfig;
import com.arrl.radiocraft.api.capabilities.IVHFHandheldCapability;
import com.arrl.radiocraft.client.RadiocraftClientValues;
import com.arrl.radiocraft.client.screens.widgets.Dial;
import com.arrl.radiocraft.client.screens.widgets.HoldButton;
import com.arrl.radiocraft.client.screens.widgets.HoverableImageButton;
import com.arrl.radiocraft.client.screens.widgets.LedIndicator;
import com.arrl.radiocraft.client.screens.widgets.MeterNeedleIndicator;
import com.arrl.radiocraft.client.screens.widgets.ToggleButton;
import com.arrl.radiocraft.common.capabilities.RadiocraftCapabilities;
import com.arrl.radiocraft.common.network.serverbound.SHandheldRadioUpdatePacket;
import com.arrl.radiocraft.common.radio.Band;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VHFHandheldScreen
extends Screen {
    public static final ResourceLocation TEXTURE = Radiocraft.id("textures/gui/vhf_handheld.png");
    public static final ResourceLocation WIDGETS_TEXTURE = Radiocraft.id("textures/gui/vhf_handheld_widgets.png");
    protected static final int imageWidth = 157;
    protected static final int imageHeight = 248;
    protected int leftPos;
    protected int topPos;
    protected final int index;
    protected ItemStack item;
    protected IVHFHandheldCapability cap;
    protected static int FREQUENCY_ENTERING_TIMEOUT = 7000;
    private final FrequencyEntryState frequencyEntryState = new FrequencyEntryState(this);
    protected Dial micGainDial;
    protected Dial gainDial;
    protected MenuState menuState = MenuState.DEFAULT;
    LedIndicator TX_LED;
    LedIndicator RX_LED;
    LedIndicator DATA_LED;
    MeterNeedleIndicator POWER_METER;

    public VHFHandheldScreen(int index) {
        super((Component)Component.translatable((String)Radiocraft.translationKey("screen", "vhf_handheld")));
        this.index = index;
        this.updateCap();
        if (this.cap == null) {
            this.onClose();
        }
        RadiocraftClientValues.SCREEN_VOICE_ENABLED = true;
    }

    protected void updateCap() {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        this.item = Minecraft.getInstance().player.getInventory().getItem(this.index);
        this.cap = (IVHFHandheldCapability)this.item.getCapability(RadiocraftCapabilities.VHF_HANDHELDS);
        if (this.cap == null) {
            this.onClose();
        }
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - 157) / 2;
        this.topPos = (this.height - 248) / 2;
        this.TX_LED = new LedIndicator((Component)Component.literal((String)"TX LED"), this.leftPos + 32, this.topPos + 107, 10, 13, 157, 0, TEXTURE, 256, 256);
        this.RX_LED = new LedIndicator((Component)Component.literal((String)"RX LED"), this.leftPos + 44, this.topPos + 107, 10, 13, 167, 0, TEXTURE, 256, 256);
        this.DATA_LED = new LedIndicator((Component)Component.literal((String)"Data LED"), this.leftPos + 56, this.topPos + 107, 10, 13, 167, 0, TEXTURE, 256, 256);
        this.POWER_METER = new MeterNeedleIndicator((Component)Component.literal((String)"Power"), MeterNeedleIndicator.MeterNeedleType.METER_HORIZONTAL, 33, this.leftPos + 33, this.topPos + 126, 2, 20, 232, 0, WIDGETS_TEXTURE, 256, 256);
        this.addRenderableWidget((GuiEventListener)new ToggleButton(this.cap.isPowered(), this.leftPos + 1, this.topPos + 37, 18, 38, 0, 0, WIDGETS_TEXTURE, 256, 256, this::onPressPower));
        this.addRenderableWidget((GuiEventListener)new HoldButton(this.leftPos - 1, this.topPos + 80, 20, 101, 36, 0, WIDGETS_TEXTURE, 256, 256, this::onPressPTT, this::onReleasePTT));
        this.micGainDial = new Dial(this.leftPos + 66, this.topPos - 1, 37, 21, 76, 0, WIDGETS_TEXTURE, 256, 256, this::onMicGainUp, this::onMicGainDown);
        this.addRenderableWidget((GuiEventListener)this.micGainDial);
        this.gainDial = new Dial(this.leftPos + 111, this.topPos - 1, 37, 21, 76, 42, WIDGETS_TEXTURE, 256, 256, this::onGainUp, this::onGainDown);
        this.addRenderableWidget((GuiEventListener)this.gainDial);
        this.addRenderableWidget((GuiEventListener)new HoverableImageButton(this.leftPos + 105, this.topPos + 168, 18, 14, 94, 84, 76, 84, WIDGETS_TEXTURE, 256, 256, this::onFrequencyButtonUp));
        this.addRenderableWidget((GuiEventListener)new HoverableImageButton(this.leftPos + 125, this.topPos + 168, 18, 14, 94, 98, 76, 98, WIDGETS_TEXTURE, 256, 256, this::onFrequencyButtonDown));
        this.addRenderableWidget((GuiEventListener)new HoverableImageButton(this.leftPos + 54, this.topPos + 225, 20, 14, 172, 0, 152, 0, WIDGETS_TEXTURE, 256, 256, b -> this.onNum(0)));
        for (int i = 1; i < 10; ++i) {
            int num = i;
            this.addRenderableWidget((GuiEventListener)new HoverableImageButton(this.leftPos + 29 + (i - 1) % 3 * 25, this.topPos + 168 + (i - 1) / 3 * 19, 20, 14, 172, i * 14, 152, i * 14, WIDGETS_TEXTURE, 256, 256, b -> this.onNum(num)));
        }
        this.addRenderableWidget((GuiEventListener)new HoverableImageButton(this.leftPos + 103, this.topPos + 225, 42, 14, 192, 112, 192, 42, WIDGETS_TEXTURE, 256, 256, this::onPressEnter));
        this.addRenderableWidget((GuiEventListener)this.TX_LED);
        this.addRenderableWidget((GuiEventListener)this.RX_LED);
        this.addRenderableWidget((GuiEventListener)this.DATA_LED);
        this.addRenderableWidget((GuiEventListener)this.POWER_METER);
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        String strValue;
        this.updateCap();
        if (this.cap == null) {
            return;
        }
        if (this.menuState == MenuState.SET_FREQ && this.frequencyEntryState.hasTimedOut()) {
            this.frequencyEntryState.reset();
            this.menuState = MenuState.DEFAULT;
        }
        this.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        int edgeSpacingX = (this.width - 157) / 2;
        int edgeSpacingY = (this.height - 248) / 2;
        pGuiGraphics.blit(TEXTURE, edgeSpacingX, edgeSpacingY, 0, 0, 157, 248);
        if (this.cap.isPowered() && this.cap.isPTTDown()) {
            this.POWER_METER.setValue(1.0);
        } else if (this.cap.isPowered()) {
            if (this.cap.getReceiveStrength() <= 0.0f) {
                this.POWER_METER.setValue(Math.random() / 10.0);
            } else {
                this.POWER_METER.setValue(Math.log10(this.cap.getReceiveStrength() / 5.0f));
                System.out.println(this.cap.getReceiveStrength() + " " + Math.log10(this.cap.getReceiveStrength() / 5.0f));
            }
        } else {
            this.POWER_METER.setValue(0.0);
        }
        if (this.cap.isPowered()) {
            if (this.menuState == MenuState.DEFAULT) {
                pGuiGraphics.drawString(this.font, String.format("%03.3f MHz", Float.valueOf(this.cap.getFrequencyHertz() / 1000000.0f)), this.leftPos + 80, this.topPos + 119, 0xFFFFFF);
            } else if (this.menuState == MenuState.SET_FREQ) {
                pGuiGraphics.drawString(this.font, "Set Freq", this.leftPos + 80, this.topPos + 119, 0xFFFFFF);
                pGuiGraphics.drawString(this.font, String.format("%03.3f MHz", Float.valueOf(this.frequencyEntryState.getFrequencyHz() / 1000000.0f)), this.leftPos + 80, this.topPos + 133, 0xFFFFFF);
            }
        }
        if (this.micGainDial.isHoveredOrChanging()) {
            strValue = String.format("%d%%", Math.round(this.cap.getMicGain() * 100.0f));
            int n = this.micGainDial.getRectangle().getCenterInAxis(ScreenAxis.HORIZONTAL) - this.font.width(strValue) / 2;
            int n2 = this.micGainDial.getRectangle().getCenterInAxis(ScreenAxis.VERTICAL);
            Objects.requireNonNull(this.font);
            pGuiGraphics.drawString(this.font, strValue, n, n2 - 9 / 2, 0xFFFFFF);
        }
        if (this.gainDial.isHoveredOrChanging()) {
            strValue = String.format("%d%%", Math.round(this.cap.getGain() * 100.0f));
            int n = this.gainDial.getRectangle().getCenterInAxis(ScreenAxis.HORIZONTAL) - this.font.width(strValue) / 2;
            int n3 = this.gainDial.getRectangle().getCenterInAxis(ScreenAxis.VERTICAL);
            Objects.requireNonNull(this.font);
            pGuiGraphics.drawString(this.font, strValue, n, n3 - 9 / 2, 0xFFFFFF);
        }
        this.TX_LED.setIsOn(this.cap.isPowered() && this.cap.isPTTDown());
        this.RX_LED.setIsOn(this.cap.isPowered() && this.cap.getReceiveStrength() > 0.0f);
        this.DATA_LED.setIsOn(false);
        for (Renderable renderable : this.renderables) {
            renderable.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    public static void open(int index) {
        Minecraft.getInstance().setScreen((Screen)new VHFHandheldScreen(index));
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean value = super.mouseReleased(mouseX, mouseY, button);
        for (GuiEventListener listener : this.children()) {
            if (listener.isMouseOver(mouseX, mouseY) || !(listener instanceof Dial)) continue;
            listener.mouseReleased(mouseX, mouseY, button);
        }
        return value;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == Minecraft.getInstance().options.keyInventory.getKey().getValue()) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        super.onClose();
        RadiocraftClientValues.SCREEN_PTT_PRESSED = false;
        RadiocraftClientValues.SCREEN_VOICE_ENABLED = false;
        RadiocraftClientValues.SCREEN_CW_ENABLED = false;
        if (this.cap.isPTTDown()) {
            this.cap.setPTTDown(false);
            this.updateServer();
        }
    }

    protected void doNothing(AbstractWidget button) {
    }

    protected void onNum(int num) {
        if (!this.cap.isPowered()) {
            return;
        }
        if (this.menuState == MenuState.DEFAULT) {
            this.menuState = MenuState.SET_FREQ;
            this.frequencyEntryState.reset();
        }
        if (this.menuState == MenuState.SET_FREQ) {
            this.frequencyEntryState.appendDigit(num);
        }
    }

    private void onPressEnter(Button button) {
        if (!this.cap.isPowered()) {
            return;
        }
        if (this.menuState == MenuState.SET_FREQ) {
            float requestedFrequency = this.frequencyEntryState.getFrequencyHz();
            if (requestedFrequency >= Band.getBand(2).minFrequency() && requestedFrequency <= Band.getBand(2).maxFrequency()) {
                this.cap.setFrequencyHertz(requestedFrequency);
            }
            this.updateServer();
            this.frequencyEntryState.reset();
            this.menuState = MenuState.DEFAULT;
        }
    }

    protected void onFrequencyButtonUp(Button button) {
        if (!this.cap.isPowered()) {
            return;
        }
        this.cap.setFrequencyHertz(Math.min(this.cap.getFrequencyHertz() + (float)((Integer)RadiocraftServerConfig.VHF_FREQUENCY_STEP.get()).intValue(), Band.getBand(2).maxFrequency()));
        this.updateServer();
    }

    protected void onFrequencyButtonDown(Button button) {
        if (!this.cap.isPowered()) {
            return;
        }
        this.cap.setFrequencyHertz(Math.max(this.cap.getFrequencyHertz() - (float)((Integer)RadiocraftServerConfig.VHF_FREQUENCY_STEP.get()).intValue(), Band.getBand(2).minFrequency()));
        this.updateServer();
    }

    protected void onGainUp(Dial dial) {
        this.cap.setGain(Math.min(this.cap.getGain() + 0.1f, ((Double)RadiocraftServerConfig.HANDHELD_MAX_GAIN.get()).floatValue()));
        this.updateServer();
    }

    protected void onGainDown(Dial dial) {
        this.cap.setGain(Math.max(this.cap.getGain() - 0.1f, 0.0f));
        this.updateServer();
    }

    protected void onMicGainUp(Dial dial) {
        this.cap.setMicGain(Math.min(this.cap.getMicGain() + 0.1f, ((Double)RadiocraftServerConfig.HANDHELD_MAX_MIC_GAIN.get()).floatValue()));
        this.updateServer();
    }

    protected void onMicGainDown(Dial dial) {
        this.cap.setMicGain(Math.max(this.cap.getMicGain() - 0.1f, 0.0f));
        this.updateServer();
    }

    protected void onPressPTT(HoldButton button) {
        this.cap.setPTTDown(true);
        RadiocraftClientValues.SCREEN_PTT_PRESSED = true;
        this.updateServer();
    }

    protected void onReleasePTT(HoldButton button) {
        this.cap.setPTTDown(false);
        RadiocraftClientValues.SCREEN_PTT_PRESSED = false;
        this.updateServer();
    }

    protected void onPressPower(ToggleButton button) {
        this.cap.setPowered(!this.cap.isPowered());
        this.updateServer();
    }

    protected void updateServer() {
        SHandheldRadioUpdatePacket.updateServer(this.index, this.cap);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private final class FrequencyEntryState {
        private static final int MAX_DIGITS = 6;
        private float frequencyHz;
        private int digitsEntered;
        private long lastInteractionAt;

        private FrequencyEntryState(VHFHandheldScreen vHFHandheldScreen) {
        }

        void appendDigit(int digit) {
            if (this.digitsEntered >= 6) {
                return;
            }
            if (this.digitsEntered == 0) {
                this.frequencyHz = 0.0f;
            }
            float placeValue = (float)Math.pow(10.0, (double)(6 - this.digitsEntered) + 2.0);
            this.frequencyHz += placeValue * (float)digit;
            ++this.digitsEntered;
            this.lastInteractionAt = System.currentTimeMillis();
        }

        float getFrequencyHz() {
            return this.frequencyHz;
        }

        boolean hasTimedOut() {
            if (this.digitsEntered <= 0) {
                return false;
            }
            long elapsed = System.currentTimeMillis() - this.lastInteractionAt;
            return elapsed > (long)FREQUENCY_ENTERING_TIMEOUT;
        }

        void reset() {
            this.frequencyHz = 0.0f;
            this.digitsEntered = 0;
            this.lastInteractionAt = 0L;
        }
    }

    protected static enum MenuState {
        DEFAULT,
        SET_FREQ;

    }
}

