/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.screens.widgets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class Dial
extends AbstractWidget {
    private final ResourceLocation resourceLocation;
    private final int u;
    private final int v;
    private final int textureWidth;
    private final int textureHeight;
    private final OnValueChanged onValueUp;
    private final OnValueChanged onValueDown;
    private boolean isRotated;
    private boolean isMouseDown;
    private int xMouseLast;

    public Dial(int x, int y, int width, int height, int u, int v, ResourceLocation texLocation, int texWidth, int texHeight, OnValueChanged onValueUp, OnValueChanged onValueDown) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.onValueUp = onValueUp;
        this.onValueDown = onValueDown;
        this.resourceLocation = texLocation;
        this.u = u;
        this.v = v;
        this.textureWidth = texWidth;
        this.textureHeight = texHeight;
    }

    protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.isMouseDown) {
            double xMouseDiff = pMouseX - this.xMouseLast;
            if (xMouseDiff > 10.0) {
                this.onValueUp.execute(this);
                this.xMouseLast = pMouseX;
                this.isRotated = !this.isRotated;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.NOTE_BLOCK_HAT, (float)1.0f));
            } else if (xMouseDiff < -10.0) {
                this.onValueDown.execute(this);
                this.xMouseLast = pMouseX;
                this.isRotated = !this.isRotated;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.NOTE_BLOCK_HAT, (float)1.0f));
            }
        }
        int xBlit = !this.isHovered() && !this.isMouseDown ? this.u : this.u + this.width;
        int yBlit = !this.isRotated ? this.v : this.v + this.height;
        pGuiGraphics.blit(this.resourceLocation, this.getX(), this.getY(), (float)xBlit, (float)yBlit, this.width, this.height, this.textureWidth, this.textureHeight);
    }

    public void onClick(double x, double y, int button) {
        if (button == 0) {
            this.isMouseDown = true;
            this.xMouseLast = (int)Math.round(x);
        }
    }

    public void onRelease(double x, double y) {
        if (this.isMouseDown) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.3f));
            this.isMouseDown = false;
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public boolean isHoveredOrChanging() {
        return this.isHovered() || this.isMouseDown;
    }

    @FunctionalInterface
    public static interface OnValueChanged {
        public void execute(Dial var1);
    }
}

