/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class HoldButton
extends AbstractWidget {
    private final ResourceLocation resourceLocation;
    private final int u;
    private final int v;
    private final int textureWidth;
    private final int textureHeight;
    private final OnInteract onPress;
    private final OnInteract onRelease;
    private boolean isPressed = false;

    public HoldButton(int x, int y, int width, int height, int u, int v, ResourceLocation texLocation, int texWidth, int texHeight, OnInteract onPress, OnInteract onRelease) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.onPress = onPress;
        this.onRelease = onRelease;
        this.resourceLocation = texLocation;
        this.u = u;
        this.v = v;
        this.textureWidth = texWidth;
        this.textureHeight = texHeight;
    }

    protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.isPressed && !this.clicked(pMouseX, pMouseY)) {
            this.onRelease(pMouseX, pMouseY);
        }
        int xBlit = !this.isHovered() ? this.u : this.u + this.width;
        int yBlit = !this.isPressed ? this.v : this.v + this.height;
        RenderSystem.enableDepthTest();
        pGuiGraphics.blit(this.resourceLocation, this.getX(), this.getY(), (float)xBlit, (float)yBlit, this.width, this.height, this.textureWidth, this.textureHeight);
    }

    public void onClick(double x, double y, int button) {
        if (button == 0) {
            this.isPressed = true;
            this.onPress.execute(this);
        }
    }

    public void onRelease(double x, double y) {
        if (this.isPressed) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.3f));
            this.isPressed = false;
            this.onRelease.execute(this);
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    @FunctionalInterface
    public static interface OnInteract {
        public void execute(HoldButton var1);
    }
}

