/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.screens.widgets;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class HoverableImageButton
extends Button {
    private final ResourceLocation resourceLocation;
    private final int uHover;
    private final int vHover;
    private final int uPressed;
    private final int vPressed;
    private final int textureWidth;
    private final int textureHeight;
    private boolean isPressed = false;

    public HoverableImageButton(int x, int y, int width, int height, int uHover, int vHover, int uPressed, int vPressed, ResourceLocation resourceLocation, int textureWidth, int textureHeight, Button.OnPress onPress) {
        super(x, y, width, height, CommonComponents.EMPTY, onPress, DEFAULT_NARRATION);
        this.resourceLocation = resourceLocation;
        this.uHover = uHover;
        this.vHover = vHover;
        this.uPressed = uPressed;
        this.vPressed = vPressed;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.isPressed) {
            pGuiGraphics.blit(this.resourceLocation, this.getX(), this.getY(), (float)this.uPressed, (float)this.vPressed, this.width, this.height, this.textureWidth, this.textureHeight);
        } else if (this.isHovered()) {
            pGuiGraphics.blit(this.resourceLocation, this.getX(), this.getY(), (float)this.uHover, (float)this.vHover, this.width, this.height, this.textureWidth, this.textureHeight);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.height) && button == 0 && this.isHoveredOrFocused()) {
            this.isPressed = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.height) && button == 0) {
            this.isPressed = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(Button var1);
    }
}

